/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hana.snapshot;

import java.sql.SQLException;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.ResultSetCacheHana;
import liquibase.structure.core.Schema;

public class ResultSetExtractorHana
extends ResultSetCacheHana.SingleResultSetExtractor {
    private DatabaseSnapshot databaseSnapshot;
    private Database database;
    private String catalogName;
    private String schemaName;
    private String tableName;

    public ResultSetExtractorHana(DatabaseSnapshot databaseSnapshot, String catalogName, String schemaName, String tableName) {
        super(databaseSnapshot.getDatabase());
        this.databaseSnapshot = databaseSnapshot;
        this.database = databaseSnapshot.getDatabase();
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    @Override
    protected boolean shouldBulkSelect(String schemaKey, ResultSetCacheHana ResultSetCacheHana2) {
        return this.tableName == null || this.getAllCatalogsStringScratchData() != null || super.shouldBulkSelect(schemaKey, ResultSetCacheHana2);
    }

    public boolean bulkContainsSchema(String schemaKey) {
        return false;
    }

    public String getSchemaKey(CachedRow row) {
        return row.getString("CONSTRAINT_SCHEM");
    }

    public ResultSetCacheHana.RowData rowKeyParameters(CachedRow row) {
        return new ResultSetCacheHana.RowData(this.catalogName, this.schemaName, this.database, row.getString("TABLE_NAME"));
    }

    public ResultSetCacheHana.RowData wantedKeyParameters() {
        return new ResultSetCacheHana.RowData(this.catalogName, this.schemaName, this.database, this.tableName);
    }

    public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(this.catalogName, this.schemaName).customize(this.database);
        return this.executeAndExtract(this.createSql(((AbstractJdbcDatabase)this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)this.database).getJdbcSchemaName(catalogAndSchema), this.tableName), this.database, false);
    }

    public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(this.catalogName, this.schemaName).customize(this.database);
        return this.executeAndExtract(this.createSql(((AbstractJdbcDatabase)this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)this.database).getJdbcSchemaName(catalogAndSchema), null), this.database);
    }

    private String createSql(String catalog, String schema, String table) {
        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalog, schema).customize(this.database);
        String jdbcSchemaName = this.database.correctObjectName(((AbstractJdbcDatabase)this.database).getJdbcSchemaName(catalogAndSchema), Schema.class);
        String sql = "select CONSTRAINT_NAME, 'UNIQUE' AS CONSTRAINT_TYPE, TABLE_NAME from " + this.database.getSystemSchema() + ".constraints where SCHEMA_NAME='" + jdbcSchemaName + "' and IS_UNIQUE_KEY='TRUE' AND IS_PRIMARY_KEY='FALSE'";
        if (table != null) {
            sql = sql + " and table_name='" + table + "'";
        }
        return sql;
    }

    private String getAllCatalogsStringScratchData() {
        return (String)this.databaseSnapshot.getScratchData("DatabaseSnapshot.allCatalogsString");
    }
}

