/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.erd.ui.model;

import java.util.LinkedHashMap;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.erd.ui.part.PropertyAwarePart;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class ERDEditUtils {
    public static boolean canRenameDatabaseObject(PropertyAwarePart part) {
        Object object;
        if (part.getCommandContext() == null || !part.getDiagram().isEditEnabled()) {
            return false;
        }
        Object model = part.getModel();
        if (model instanceof ERDObject && (object = ((ERDObject)model).getObject()) instanceof DBSObject) {
            DBEObjectRenamer objectRenamer = (DBEObjectRenamer)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectRenamer.class);
            return objectRenamer != null && objectRenamer.canRenameObject((DBSObject)object);
        }
        return false;
    }

    public static boolean renameDatabaseObject(DBECommandContext commandContext, DBSObject object, String newName, Object uiSource) {
        block3: {
            try {
                DBEObjectRenamer objectRenamer = (DBEObjectRenamer)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectRenamer.class);
                if (objectRenamer == null || !objectRenamer.canRenameObject(object)) break block3;
                LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
                options.put("uiSource", uiSource);
                objectRenamer.renameObject(commandContext, object, options, newName);
                return true;
            }
            catch (Throwable e) {
                DBWorkbench.getPlatformUI().showError("Rename object", "Can't rename object '" + object.getName() + "'", e);
                return false;
            }
        }
        throw new DBException("Object rename not supported");
    }

    public static boolean canDeleteDatabaseObject(PropertyAwarePart part) {
        Object object;
        if (part.getCommandContext() == null || !part.getDiagram().isEditEnabled()) {
            return false;
        }
        Object model = part.getModel();
        if (model instanceof ERDObject && (object = ((ERDObject)model).getObject()) instanceof DBSObject) {
            DBEObjectMaker objectManager = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectMaker.class);
            return objectManager != null && objectManager.canDeleteObject((DBSObject)object);
        }
        return false;
    }

    public static boolean deleteDatabaseObject(DBECommandContext commandContext, DBSObject object) {
        block3: {
            try {
                DBEObjectMaker objectManager = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectMaker.class);
                if (objectManager == null || !objectManager.canDeleteObject(object)) break block3;
                LinkedHashMap options = new LinkedHashMap();
                objectManager.deleteObject(commandContext, object, options);
                return true;
            }
            catch (Throwable e) {
                DBWorkbench.getPlatformUI().showError("Delete object", "Can't delete object '" + object.getName() + "'", e);
                return false;
            }
        }
        throw new DBException("Object delete not supported");
    }
}

