/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.erd.ui.command;

import com.dbeaver.ee.erd.ui.model.ERDEditUtils;
import org.eclipse.gef3.commands.Command;
import org.jkiss.dbeaver.erd.ui.model.ERDDatabaseObjectModifyCommand;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class EntityRenameCommand
extends Command
implements ERDDatabaseObjectModifyCommand {
    private EntityPart entity;
    private String newText;
    private String oldText;

    public EntityRenameCommand(EntityPart entity, String newText) {
        super("Set entity name");
        this.entity = entity;
        this.oldText = this.entity.getName();
        this.newText = newText;
    }

    public void execute() {
        this.renameEntity(this.newText);
    }

    public void undo() {
        this.renameEntity(this.oldText);
        this.entity.handleNameChange();
    }

    private boolean renameEntity(String newName) {
        if (CommonUtils.equalObjects((Object)this.entity.getEntity().getName(), (Object)newName)) {
            return false;
        }
        DBECommandContext commandContext = this.entity.getCommandContext();
        if (commandContext == null) {
            return false;
        }
        return ERDEditUtils.renameDatabaseObject(commandContext, (DBSObject)this.entity.getEntity().getObject(), newName, this.entity.getEditor());
    }

    public DBSObject getDatabaseObject() {
        return (DBSObject)this.entity.getEntity().getObject();
    }
}

