/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceInvalidateHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceToolbarUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class DataSourceReadonlyHandler
extends AbstractDataSourceHandler
implements IElementUpdater {
    private DataSourceDescriptor currentDescriptor = null;

    @Nullable
    public Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
        DataSourceDescriptor dataSourceContainer = this.currentDescriptor;
        if (dataSourceContainer != null) {
            DBPDataSource dataSource;
            dataSourceContainer.setConnectionReadOnly(!dataSourceContainer.isConnectionReadOnly());
            dataSourceContainer.persistConfiguration();
            if (dataSourceContainer.isConnected() && (dataSource = dataSourceContainer.getDataSource()) != null && !DataSourceInvalidateHandler.invalidateDataSource(dataSource)) {
                dataSourceContainer.setConnectionReadOnly(!dataSourceContainer.isConnectionReadOnly());
            }
            DataSourceToolbarUtils.triggerRefreshReadonlyElement();
        }
        return null;
    }

    public void updateElement(@NotNull UIElement element, @Nullable Map parameters) {
        DataSourceDescriptor descriptor;
        DBPDataSourceContainer container = DataSourceReadonlyHandler.getActiveDataSourceContainer((IWorkbenchWindow)element.getServiceLocator().getService(IWorkbenchWindow.class));
        DataSourceDescriptor dataSourceDescriptor = descriptor = container instanceof DataSourceDescriptor ? (DataSourceDescriptor)container : null;
        if (descriptor != this.currentDescriptor) {
            this.currentDescriptor = descriptor;
        }
        if (this.currentDescriptor != null) {
            boolean isReadonly = this.currentDescriptor.isConnectionReadOnly();
            if (isReadonly) {
                element.setTooltip(NLS.bind((String)CoreMessages.toolbar_checkbox_connection_not_readonly_tooltip, (Object)this.currentDescriptor.getName()));
                element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_READONLY));
            } else {
                element.setTooltip(NLS.bind((String)CoreMessages.toolbar_checkbox_connection_readonly_tooltip, (Object)this.currentDescriptor.getName()));
                element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_UNLOCKED));
            }
            element.setChecked(isReadonly);
        } else {
            element.setChecked(false);
            element.setTooltip(CoreMessages.dialog_connection_wizard_final_checkbox_connection_readonly);
            element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_UNLOCKED));
        }
    }

    @Nullable
    private static DBPDataSourceContainer getActiveDataSourceContainer(@NotNull IWorkbenchWindow window) {
        if (window != null) {
            IWorkbenchPart activePart;
            DBPDataSourceContainer container;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (container = DataSourceReadonlyHandler.getDataSourceContainerFromPart((IWorkbenchPart)(activePart = page.getActivePart()))) != null) {
                return container;
            }
            ISelection selection = window.getSelectionService().getSelection();
            if (selection != null) {
                DBPDataSource dataSource;
                DBSObject selectedObject = NavigatorUtils.getSelectedObject((ISelection)selection);
                if (selectedObject instanceof DBPDataSourceContainer) {
                    return (DBPDataSourceContainer)selectedObject;
                }
                if (selectedObject != null && (dataSource = selectedObject.getDataSource()) != null) {
                    return dataSource.getContainer();
                }
            }
        }
        return null;
    }
}

