/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.navigator.fs;

import com.dbeaver.cloud.internal.CloudUIMessages;
import com.dbeaver.cloud.model.navigator.CPCloudRegionProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationListener;
import com.dbeaver.cloud.registry.CPCloudConfigurationRegistry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.DBNEmptyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystems;
import org.jkiss.dbeaver.model.navigator.fs.DBNPath;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseBrowserView;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ByteNumberFormat;

public class CloudFileSystemExplorerView
extends DatabaseBrowserView
implements CPCloudConfigurationListener {
    private static final String VIEW_ID = "com.dbeaver.cloud.fsExplorerView";
    private static final Log log = Log.getLog(CloudFileSystemExplorerView.class);
    private ViewerColumnController columnController;
    private final NumberFormat sizeFormat = new ByteNumberFormat(ByteNumberFormat.BinaryPrefix.ISO);
    private final Set<CPCloudRegionProvider> loadingRegions = Collections.synchronizedSet(new HashSet());

    public CloudFileSystemExplorerView() {
        CPCloudConfigurationRegistry.getInstance().addConfigurationChangeListener((CPCloudConfigurationListener)this, false);
    }

    protected INavigatorFilter getNavigatorFilter() {
        return null;
    }

    public DBNNode getRootNode() {
        return super.getRootNode();
    }

    protected DBNNode getDefaultRootNode() {
        DBNProject projectNode = this.getModel().getRoot().getProjectNode(DBWorkbench.getPlatform().getWorkspace().getActiveProject());
        DBNFileSystems fsRootNode = (DBNFileSystems)projectNode.getExtraNode(DBNFileSystems.class);
        return fsRootNode == null ? new DBNEmptyNode() : fsRootNode;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TreeViewer viewer = this.getNavigatorViewer();
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof DBNProjectDatabases);
            }
        });
        viewer.getTree().setHeaderVisible(true);
        UIExecutionQueue.queueExec(() -> this.createColumns(viewer));
        this.handleCloudConfigurationChange();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void handleCloudConfigurationChange() {
        DBNProject projectNode = this.getModel().getRoot().getProjectNode(DBWorkbench.getPlatform().getWorkspace().getActiveProject());
        DBNFileSystems fsRootNode = (DBNFileSystems)projectNode.getExtraNode(DBNFileSystems.class);
        if (fsRootNode != null) {
            fsRootNode.resetFileSystems();
        }
    }

    public void dispose() {
        CPCloudConfigurationRegistry.getInstance().removeConfigurationChangeListener((CPCloudConfigurationListener)this);
        super.dispose();
    }

    private void createColumns(final TreeViewer viewer) {
        viewer.getControl().getDisplay().getSystemColor(17);
        final ILabelProvider mainLabelProvider = (ILabelProvider)viewer.getLabelProvider();
        this.columnController = new ViewerColumnController("cloudFileExplorer", (ColumnViewer)viewer);
        this.columnController.setForceAutoSize(true);
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_name_text, UINavigatorMessages.navigator_project_explorer_columns_name_description, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return mainLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return mainLabelProvider.getImage(element);
            }

            public String getToolTipText(Object element) {
                if (mainLabelProvider instanceof IToolTipProvider) {
                    return ((IToolTipProvider)mainLabelProvider).getToolTipText(element);
                }
                return null;
            }
        });
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_size_text, UINavigatorMessages.navigator_project_explorer_columns_size_description, 131072, true, false, true, null, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Path path;
                if (element instanceof DBNPath && (path = ((DBNPathBase)element).getPath()) != null && Files.isRegularFile(path, new LinkOption[0])) {
                    try {
                        return CloudFileSystemExplorerView.this.sizeFormat.format(Files.size(path));
                    }
                    catch (IOException e) {
                        log.debug((Object)e);
                    }
                }
                return "";
            }
        }, null);
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_modified_text, UINavigatorMessages.navigator_project_explorer_columns_modified_description, 131072, true, false, (CellLabelProvider)new ColumnLabelProvider(){
            private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

            public String getText(Object element) {
                Path path;
                if (element instanceof DBNPath && (path = ((DBNPathBase)element).getPath()) != null && Files.isRegularFile(path, new LinkOption[0])) {
                    try {
                        FileTime lastModified = Files.getLastModifiedTime(path, new LinkOption[0]);
                        return this.sdf.format(lastModified.toMillis());
                    }
                    catch (IOException e) {
                        log.debug((Object)e);
                    }
                }
                return "";
            }
        });
        this.columnController.addColumn(CloudUIMessages.cloud_file_explorer_columns_region_text, CloudUIMessages.cloud_file_explorer_columns_region_tip, 131072, true, false, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(final Object element) {
                DBFVirtualFileSystemRoot root;
                if (element instanceof DBNFileSystemRoot && (root = ((DBNFileSystemRoot)element).getRoot()) instanceof CPCloudRegionProvider) {
                    try {
                        final CPCloudRegionProvider provider = (CPCloudRegionProvider)root;
                        String region = provider.getCloudRegion(null);
                        if (region != null) {
                            return region;
                        }
                        if (CloudFileSystemExplorerView.this.loadingRegions.add(provider)) {
                            AbstractJob job = new AbstractJob("Load cloud region name"){

                                protected IStatus run(DBRProgressMonitor monitor) {
                                    try {
                                        provider.getCloudRegion(monitor);
                                        return Status.OK_STATUS;
                                    }
                                    catch (DBException e) {
                                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                                    }
                                }
                            };
                            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                                public void done(IJobChangeEvent event) {
                                    (this).CloudFileSystemExplorerView.this.loadingRegions.remove(provider);
                                    UIUtils.asyncExec(() -> viewer.refresh(element));
                                }
                            });
                            job.setUser(false);
                            job.setSystem(true);
                            job.schedule();
                        }
                    }
                    catch (DBException e) {
                        log.warn((Object)"Error loading cloud region", (Throwable)e);
                    }
                    return "...";
                }
                return "";
            }
        });
        UIUtils.asyncExec(() -> this.columnController.createColumns(true));
    }
}

