/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.explorer;

import com.dbeaver.cloud.internal.CloudUIMessages;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;

class NewConfigurationDialog
extends EnterNameDialog {
    private final List<CloudProviderDescriptor> cloudProviders = CloudProviderRegistry.getInstance().getCloudProviders();
    private final Function<CloudProviderDescriptor, String> cloudNameGenerator;
    private Combo typeCombo;
    private CloudProviderDescriptor selectedCloudProvider;

    NewConfigurationDialog(@Nullable Shell parentShell, @NotNull Function<CloudProviderDescriptor, String> cloudNameGenerator) {
        super(parentShell, CloudUIMessages.cloud_conf_edit_page_configuration_name_property, null);
        this.cloudNameGenerator = cloudNameGenerator;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)"DBeaver.NewCloudConfigurationDialog");
    }

    protected void createControlsBeforeName(Composite composite) {
        UIUtils.createControlLabel((Composite)composite, (String)CloudUIMessages.new_config_dialog_label_combo_cloud_type);
        this.typeCombo = new Combo(composite, 12);
        this.typeCombo.setLayoutData((Object)new GridData(768));
        for (CloudProviderDescriptor cpDescriptor : this.cloudProviders) {
            this.typeCombo.add(cpDescriptor.getDisplayName());
        }
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationDialog.this.selectedCloudProvider = NewConfigurationDialog.this.cloudProviders.get(NewConfigurationDialog.this.typeCombo.getSelectionIndex());
                NewConfigurationDialog.this.propNameText.setText(NewConfigurationDialog.this.cloudNameGenerator.apply(NewConfigurationDialog.this.selectedCloudProvider));
            }
        });
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        this.typeCombo.select(0);
        this.typeCombo.notifyListeners(13, new Event());
        return composite;
    }

    @NotNull
    public CloudProviderDescriptor getSelectedCloudProvider() {
        return this.selectedCloudProvider;
    }
}

