/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.explorer;

import org.eclipse.swt.widgets.Event;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorNodeActionHandlerAbstract;

public class NNAHDataSourceCloud
extends NavigatorNodeActionHandlerAbstract {
    public boolean isEnabledFor(INavigatorModelView view, DBNNode node) {
        if (node instanceof DBNDataSource) {
            return !"local".equals(((DBNDataSource)node).getDataSourceContainer().getOrigin().getType());
        }
        return false;
    }

    public DBPImage getNodeActionIcon(INavigatorModelView view, DBNNode node) {
        return UIIcon.BUTTON_CLOUD;
    }

    public String getNodeActionToolTip(INavigatorModelView view, DBNNode node) {
        return ((DBNDataSource)node).getDataSourceContainer().getOrigin().getDisplayName();
    }

    public void handleNodeAction(INavigatorModelView view, DBNNode node, Event event, boolean defaultAction) {
        if (node instanceof DBNDataSource) {
            DBPDataSourceContainer dataSourceContainer = ((DBNDataSource)node).getDataSourceContainer();
            UIServiceConnections serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class);
            if (serviceConnections != null) {
                serviceConnections.openConnectionEditor(dataSourceContainer, "CloudConnectionPage");
            }
        }
    }
}

