/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse;
import software.amazon.awssdk.services.redshift.model.MaintenanceTrack;

public class DescribeClusterTracksPublisher
implements SdkPublisher<DescribeClusterTracksResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeClusterTracksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClusterTracksPublisher(RedshiftAsyncClient client, DescribeClusterTracksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClusterTracksPublisher(RedshiftAsyncClient client, DescribeClusterTracksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClusterTracksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClusterTracksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MaintenanceTrack> maintenanceTracks() {
        Function<DescribeClusterTracksResponse, Iterator> getIterator = response -> {
            if (response != null && response.maintenanceTracks() != null) {
                return response.maintenanceTracks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeClusterTracksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeClusterTracksResponseFetcher
    implements AsyncPageFetcher<DescribeClusterTracksResponse> {
        private DescribeClusterTracksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterTracksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeClusterTracksResponse> nextPage(DescribeClusterTracksResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterTracksPublisher.this.client.describeClusterTracks(DescribeClusterTracksPublisher.this.firstRequest);
            }
            return DescribeClusterTracksPublisher.this.client.describeClusterTracks((DescribeClusterTracksRequest)((Object)DescribeClusterTracksPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

