/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.debug.core;

import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class PostgreSqlDebugCore {
    public static final String BUNDLE_SYMBOLIC_NAME = "org.jkiss.dbeaver.ext.postgresql.debug.core";

    public static void saveFunction(PostgreProcedure procedure, Map<String, Object> configuration) {
        PostgreDataSource dataSource = (PostgreDataSource)procedure.getDataSource();
        DBPDataSourceContainer dataSourceContainer = dataSource.getContainer();
        String databaseName = procedure.getDatabase().getName();
        String schemaName = procedure.getSchema().getName();
        configuration.put("org.jkiss.dbeaver.debug.core.ATTR_PROJECT_NAME", dataSourceContainer.getProject().getName());
        configuration.put("org.jkiss.dbeaver.debug.core.ATTR_DATASOURCE_ID", dataSourceContainer.getId());
        configuration.put("org.jkiss.dbeaver.debug.core.ATTR_DEBUG_TYPE", "org.jkiss.dbeaver.ext.postgresql.debug.function");
        configuration.put("PG.ATTR_DATABASE_NAME", databaseName);
        configuration.put("PG.ATTR_SCHEMA_NAME", schemaName);
        configuration.put("PG.ATTR_FUNCTION_OID", String.valueOf(procedure.getObjectId()));
    }

    public static PostgreProcedure resolveFunction(DBRProgressMonitor monitor, DBPDataSourceContainer dsContainer, Map<String, Object> configuration) throws DBException {
        if (!dsContainer.isConnected()) {
            dsContainer.connect(monitor, true, true);
        }
        long functionId = CommonUtils.toLong((Object)configuration.get("PG.ATTR_FUNCTION_OID"));
        String databaseName = (String)configuration.get("PG.ATTR_DATABASE_NAME");
        String schemaName = (String)configuration.get("PG.ATTR_SCHEMA_NAME");
        PostgreDataSource ds = (PostgreDataSource)dsContainer.getDataSource();
        PostgreDatabase database = ds.getDatabase(databaseName);
        if (database != null) {
            PostgreSchema schema = database.getSchema(monitor, schemaName);
            if (schema != null) {
                PostgreProcedure function = schema.getProcedure(monitor, functionId);
                if (function != null) {
                    return function;
                }
                throw new DBException("Function " + functionId + " not found in schema " + schemaName);
            }
            throw new DBException("Schema '" + schemaName + "' not found in database " + databaseName);
        }
        throw new DBException("Database '" + databaseName + "' not found");
    }
}

