/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.model;

import com.dbeaver.ee.influxdb.InfluxConstants;
import com.dbeaver.ee.influxdb.exec.InfluxExecutionContext;
import com.dbeaver.ee.influxdb.exec.InfluxSession;
import com.dbeaver.ee.influxdb.model.InfluxDataSource;
import com.dbeaver.ee.influxdb.model.InfluxDatabase;
import com.dbeaver.ee.influxdb.model.InfluxMeasurement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.struct.DirectObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class InfluxStructureAssistant
implements DBSStructureAssistant<InfluxExecutionContext> {
    private final InfluxDataSource dataSource;

    public InfluxStructureAssistant(InfluxDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE};
    }

    public DBSObjectType[] getSearchObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull InfluxExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws DBException {
        ArrayList<DBSObjectReference> references = new ArrayList<DBSObjectReference>();
        DBSObject parentObject = params.getParentObject();
        Throwable throwable = null;
        Object var7_8 = null;
        try (InfluxSession session = (InfluxSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)(parentObject != null ? parentObject : this.dataSource), (String)"Find Influx objects");){
            InfluxDatabase database = parentObject instanceof InfluxDatabase ? (InfluxDatabase)parentObject : executionContext.getDefaultCatalog();
            this.findCollections(session, database, params, references);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return references;
    }

    private void findCollections(InfluxSession session, @NotNull InfluxDatabase database, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws DBException {
        String colNameMask = params.getMask();
        String likePattern = colNameMask.contains("%") ? colNameMask.replace("%", ".*") : Pattern.quote(colNameMask);
        Pattern pattern = Pattern.compile(likePattern, (params.isCaseSensitive() ? 0 : 2) | 8);
        for (InfluxMeasurement table : database.getMeasurements(session.getProgressMonitor())) {
            if (!pattern.matcher(table.getName()).matches()) continue;
            objects.add((DBSObjectReference)new DirectObjectReference((DBSObject)database, InfluxConstants.TYPE_MEASUREMENT, (DBSObject)table));
        }
    }
}

