/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.copy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.copy.CopyStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class CopyPostgres
extends AbstractSqlGenerator<CopyStatement> {
    public boolean supports(CopyStatement copyStatement, Database database) {
        return database instanceof PostgresDatabase;
    }

    public ValidationErrors validate(CopyStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new ValidationErrors();
    }

    public Sql[] generateSql(CopyStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ArrayList<UnparsedSql> ret = new ArrayList<UnparsedSql>();
        String sql = "";
        try {
            String line;
            sql = sql + "COPY ";
            sql = sql + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName());
            sql = sql + " FROM STDIN;\n";
            BufferedReader reader = new BufferedReader(new InputStreamReader(statement.getInputStream()));
            StringBuilder out = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                out.append(line);
            }
            sql = sql + "\\.";
            sql = sql + out.toString();
            ret.add(new UnparsedSql(sql, new DatabaseObject[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret.toArray(new Sql[ret.size()]);
    }
}

