/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandFormat {
    final int minPar;
    final int maxPar;
    final Map<String, Boolean> options = new HashMap<String, Boolean>();
    final Map<String, String> optionsWithValue = new HashMap<String, String>();
    boolean ignoreUnknownOpts = false;

    @Deprecated
    public CommandFormat(String n, int min, int max, String ... possibleOpt) {
        this(min, max, possibleOpt);
    }

    public CommandFormat(int min, int max, String ... possibleOpt) {
        this.minPar = min;
        this.maxPar = max;
        for (String opt : possibleOpt) {
            if (opt == null) {
                this.ignoreUnknownOpts = true;
                continue;
            }
            this.options.put(opt, Boolean.FALSE);
        }
    }

    public void addOptionWithValue(String option) {
        if (this.options.containsKey(option)) {
            throw new DuplicatedOptionException(option);
        }
        this.optionsWithValue.put(option, null);
    }

    public List<String> parse(String[] args, int pos) {
        ArrayList<String> parameters = new ArrayList<String>(Arrays.asList(args));
        parameters.subList(0, pos).clear();
        this.parse(parameters);
        return parameters;
    }

    public void parse(List<String> args) {
        int psize;
        String arg;
        int pos = 0;
        while (pos < args.size() && (arg = args.get(pos)).startsWith("-") && !arg.equals("-")) {
            if (arg.equals("--")) {
                args.remove(pos);
                break;
            }
            String opt = arg.substring(1);
            if (this.options.containsKey(opt)) {
                args.remove(pos);
                this.options.put(opt, Boolean.TRUE);
                continue;
            }
            if (this.optionsWithValue.containsKey(opt)) {
                args.remove(pos);
                if (pos < args.size() && args.size() > this.minPar && !args.get(pos).startsWith("-")) {
                    arg = args.get(pos);
                    args.remove(pos);
                } else {
                    arg = "";
                }
                if (arg.startsWith("-") && !arg.equals("-")) continue;
                this.optionsWithValue.put(opt, arg);
                continue;
            }
            if (this.ignoreUnknownOpts) {
                ++pos;
                continue;
            }
            throw new UnknownOptionException(arg);
        }
        if ((psize = args.size()) < this.minPar) {
            throw new NotEnoughArgumentsException(this.minPar, psize);
        }
        if (psize > this.maxPar) {
            throw new TooManyArgumentsException(this.maxPar, psize);
        }
    }

    public boolean getOpt(String option) {
        return this.options.containsKey(option) ? this.options.get(option) : false;
    }

    public String getOptValue(String option) {
        return this.optionsWithValue.get(option);
    }

    public Set<String> getOpts() {
        HashSet<String> optSet = new HashSet<String>();
        for (Map.Entry<String, Boolean> entry : this.options.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            optSet.add(entry.getKey());
        }
        return optSet;
    }

    public static class DuplicatedOptionException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 0L;

        public DuplicatedOptionException(String duplicatedOption) {
            super("option " + duplicatedOption + " already exsits!");
        }
    }

    public static class UnknownOptionException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 0L;
        protected String option = null;

        public UnknownOptionException(String unknownOption) {
            super("Illegal option " + unknownOption);
            this.option = unknownOption;
        }

        public String getOption() {
            return this.option;
        }
    }

    public static class NotEnoughArgumentsException
    extends IllegalNumberOfArgumentsException {
        private static final long serialVersionUID = 0L;

        public NotEnoughArgumentsException(int expected, int actual) {
            super(expected, actual);
        }

        @Override
        public String getMessage() {
            return "Not enough arguments: " + super.getMessage();
        }
    }

    public static class TooManyArgumentsException
    extends IllegalNumberOfArgumentsException {
        private static final long serialVersionUID = 0L;

        public TooManyArgumentsException(int expected, int actual) {
            super(expected, actual);
        }

        @Override
        public String getMessage() {
            return "Too many arguments: " + super.getMessage();
        }
    }

    public static abstract class IllegalNumberOfArgumentsException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 0L;
        protected int expected;
        protected int actual;

        protected IllegalNumberOfArgumentsException(int want, int got) {
            this.expected = want;
            this.actual = got;
        }

        @Override
        public String getMessage() {
            return "expected " + this.expected + " but got " + this.actual;
        }
    }
}

