/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class DatabaseNativeAuthModelConfigurator
implements IObjectPropertyConfigurator<DBAAuthModel<?>, DBPDataSourceContainer> {
    protected Label usernameLabel;
    protected Text usernameText;
    protected Label passwordLabel;
    protected Composite passPlaceholder;
    protected Text passwordText;
    protected Button savePasswordCheck;
    protected ToolBar userManagementToolbar;
    protected DBPDataSourceContainer dataSource;

    public void createControl(@NotNull Composite authPanel, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        boolean userNameApplicable = true;
        boolean userPasswordApplicable = true;
        if (object instanceof AuthModelDatabaseNative) {
            userNameApplicable = ((AuthModelDatabaseNative)object).isUserNameApplicable();
            userPasswordApplicable = ((AuthModelDatabaseNative)object).isUserPasswordApplicable();
        }
        if (!userNameApplicable) {
            return;
        }
        this.usernameLabel = UIUtils.createLabel((Composite)authPanel, (String)UIConnectionMessages.dialog_connection_auth_label_username);
        this.usernameLabel.setLayoutData((Object)new GridData(32));
        this.createUserNameControls(authPanel, propertyChangeListener);
        if (userPasswordApplicable) {
            this.createPasswordControls(authPanel, propertyChangeListener);
        }
    }

    protected void createUserNameControls(Composite authPanel, Runnable propertyChangeListener) {
        this.usernameText = new Text(authPanel, 2048);
        this.usernameText.setLayoutData((Object)this.makeAuthControlLayoutData(authPanel));
        this.usernameText.addModifyListener(e -> propertyChangeListener.run());
    }

    @NotNull
    private GridData makeAuthControlLayoutData(Composite authPanel) {
        int fontHeight = UIUtils.getFontHeight((Control)authPanel);
        GridData gd = new GridData(32);
        gd.widthHint = fontHeight * 20;
        return gd;
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        this.dataSource = dataSource;
        if (this.usernameText != null) {
            this.usernameText.setText(CommonUtils.notEmpty((String)dataSource.getConnectionConfiguration().getUserName()));
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)dataSource.getConnectionConfiguration().getUserPassword()));
            this.savePasswordCheck.setSelection(dataSource.isSavePassword());
            this.passwordText.setEnabled(dataSource.isSavePassword());
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        if (this.usernameText != null) {
            dataSource.getConnectionConfiguration().setUserName(this.usernameText.getText());
        }
        if (this.passwordText != null && this.isPasswordApplicable()) {
            dataSource.getConnectionConfiguration().setUserPassword(this.passwordText.getText());
        } else {
            dataSource.getConnectionConfiguration().setUserPassword(null);
        }
        if (this.savePasswordCheck != null) {
            dataSource.setSavePassword(this.savePasswordCheck.getSelection());
        }
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSource) {
        this.loadSettings(dataSource);
    }

    protected boolean isPasswordApplicable() {
        return this.passwordText != null;
    }

    public boolean isComplete() {
        return true;
    }

    protected Text createPasswordText(Composite parent, String label) {
        if (label != null) {
            UIUtils.createControlLabel((Composite)parent, (String)label);
        }
        Composite ph = UIUtils.createPlaceholder((Composite)parent, (int)1);
        ph.setLayoutData((Object)new GridData(32));
        this.passwordText = new Text(ph, 0x400800);
        this.passwordText.setLayoutData((Object)this.makeAuthControlLayoutData(ph));
        return this.passwordText;
    }

    protected void createPasswordControls(Composite parent, Runnable propertyChangeListener) {
        this.passwordLabel = UIUtils.createLabel((Composite)parent, (String)this.getPasswordFieldLabel());
        this.passwordLabel.setLayoutData((Object)new GridData(32));
        this.passPlaceholder = UIUtils.createComposite((Composite)parent, (int)2);
        this.passPlaceholder.setLayoutData((Object)new GridData(768));
        this.createPasswordText(this.passPlaceholder, null);
        this.passwordText.addModifyListener(e -> propertyChangeListener.run());
        final UIServiceSecurity serviceSecurity = (UIServiceSecurity)DBWorkbench.getService(UIServiceSecurity.class);
        boolean supportsPasswordView = serviceSecurity != null;
        Composite panel = UIUtils.createComposite((Composite)this.passPlaceholder, (int)(supportsPasswordView ? 2 : 1));
        GridData gd = new GridData(32);
        panel.setLayoutData((Object)gd);
        this.savePasswordCheck = UIUtils.createCheckbox((Composite)panel, (String)UIConnectionMessages.dialog_connection_wizard_final_checkbox_save_password_locally, (this.dataSource == null || this.dataSource.isSavePassword() ? 1 : 0) != 0);
        this.savePasswordCheck.setToolTipText(UIConnectionMessages.dialog_connection_wizard_final_checkbox_save_password_locally);
        this.savePasswordCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseNativeAuthModelConfigurator.this.passwordText.setEnabled(DatabaseNativeAuthModelConfigurator.this.savePasswordCheck.getSelection());
            }
        });
        if (supportsPasswordView) {
            this.userManagementToolbar = new ToolBar(panel, 256);
            ToolItem showPasswordLabel = new ToolItem(this.userManagementToolbar, 0);
            showPasswordLabel.setToolTipText(UIConnectionMessages.dialog_connection_auth_label_show_password);
            showPasswordLabel.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SHOW_ALL_DETAILS));
            showPasswordLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseNativeAuthModelConfigurator.this.showPasswordText(serviceSecurity);
                }
            });
        }
    }

    protected String getPasswordFieldLabel() {
        return UIConnectionMessages.dialog_connection_auth_label_password;
    }

    private void showPasswordText(UIServiceSecurity serviceSecurity) {
        boolean passHidden;
        Composite passContainer = this.passwordText.getParent();
        boolean bl = passHidden = (this.passwordText.getStyle() & 0x400000) == 0x400000;
        if (passHidden && !serviceSecurity.validatePassword(this.dataSource.getProject().getSecureStorage(), "Enter project password", "Enter project master password to unlock connection password view", true)) {
            return;
        }
        Object layoutData = this.passwordText.getLayoutData();
        String curValue = this.passwordText.getText();
        this.passwordText.dispose();
        this.passwordText = passHidden ? new Text(passContainer, 2048) : new Text(passContainer, 0x400800);
        this.passwordText.setLayoutData(layoutData);
        this.passwordText.setText(curValue);
        passContainer.layout(true, true);
    }
}

