/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.dashboard.bar;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.jkiss.dbeaver.ui.AWTUtils;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.charts.BaseChartDrawingSupplier;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardChartComposite;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardItem;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardRendererBase;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardUtils;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardValueType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewContainer;
import org.jkiss.dbeaver.ui.dashboard.model.data.DashboardDataset;
import org.jkiss.dbeaver.ui.dashboard.model.data.DashboardDatasetRow;

public class DashboardRendererBar
extends DashboardRendererBase {
    public DashboardChartComposite createDashboard(Composite composite, DashboardContainer container, DashboardViewContainer viewContainer, Point preferredSize) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        DashboardItemViewConfiguration viewConfig = viewContainer.getViewConfiguration().getDashboardConfig(container.getDashboardId());
        java.awt.Color gridColor = AWTUtils.makeAWTColor((Color)UIStyles.getDefaultTextForeground());
        JFreeChart barChart = ChartFactory.createBarChart(null, (String)"Time", (String)"Value", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        barChart.setBorderVisible(false);
        barChart.setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        barChart.setTextAntiAlias(true);
        barChart.setBackgroundPaint((Paint)AWTUtils.makeAWTColor((Color)UIStyles.getDefaultTextBackground()));
        this.createDefaultLegend(viewConfig, barChart);
        ChartPanel chartPanel = new ChartPanel(barChart);
        chartPanel.setPreferredSize(new Dimension(preferredSize.x, preferredSize.y));
        CategoryPlot plot = barChart.getCategoryPlot();
        plot.setOutlinePaint(null);
        plot.setShadowGenerator(null);
        plot.setDrawingSupplier((DrawingSupplier)new BaseChartDrawingSupplier());
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setLabel(null);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setTickLabelPaint((Paint)gridColor);
        domainAxis.setTickLabelFont(DEFAULT_TICK_LABEL_FONT);
        domainAxis.setTickLabelInsets(RectangleInsets.ZERO_INSETS);
        if (viewConfig != null && !viewConfig.isDomainTicksVisible()) {
            domainAxis.setVisible(false);
        }
        plot.setDomainGridlinesVisible(viewConfig == null || viewConfig.isGridVisible());
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setLabel(null);
        rangeAxis.setTickLabelPaint((Paint)gridColor);
        rangeAxis.setTickLabelFont(DEFAULT_TICK_LABEL_FONT);
        rangeAxis.setTickLabelInsets(RectangleInsets.ZERO_INSETS);
        if (container.getDashboardValueType() == DashboardValueType.integer) {
            rangeAxis.setStandardTickUnits((TickUnitSource)new NumberTickUnitSource(true));
        }
        if (viewConfig != null && !viewConfig.isRangeTicksVisible()) {
            rangeAxis.setVisible(false);
        }
        rangeAxis.setStandardTickUnits(DashboardUtils.getTickUnitsSource((DashboardValueType)container.getDashboardValueType()));
        plot.setRangeGridlinesVisible(viewConfig == null || viewConfig.isGridVisible());
        CategoryItemRenderer plotRenderer = plot.getRenderer();
        plotRenderer.setBaseItemLabelPaint((Paint)gridColor);
        BasicStroke stroke = new BasicStroke(2.0f, 0, 1, 10.0f, null, 0.0f);
        plot.getRenderer().setBaseStroke((Stroke)stroke);
        plot.setBackgroundPaint(barChart.getBackgroundPaint());
        plot.setDomainGridlinePaint((Paint)gridColor);
        plot.setRangeGridlinePaint((Paint)gridColor);
        DashboardChartComposite chartComposite = this.createChartComposite(composite, container, viewContainer, preferredSize);
        chartComposite.setChart(barChart);
        return chartComposite;
    }

    public void updateDashboardData(DashboardContainer container, Date lastUpdateTime, DashboardDataset dataset) {
        DashboardChartComposite chartComposite = this.getChartComposite(container);
        if (chartComposite.isDisposed()) {
            return;
        }
        CategoryPlot plot = this.getDashboardPlot(container);
        DefaultCategoryDataset chartDataset = (DefaultCategoryDataset)plot.getDataset();
        List rows = dataset.getRows();
        if (rows.isEmpty()) {
            return;
        }
        DashboardDatasetRow row = (DashboardDatasetRow)rows.get(rows.size() - 1);
        String[] srcSeries = dataset.getColumnNames();
        int i = 0;
        while (i < srcSeries.length) {
            String valueName = srcSeries[i];
            Object value = row.getValues()[i];
            if (value instanceof Number) {
                chartDataset.setValue((Number)value, (Comparable)((Object)valueName), (Comparable)((Object)valueName));
            }
            ++i;
        }
    }

    public void resetDashboardData(DashboardContainer container, Date lastUpdateTime) {
        CategoryPlot plot = this.getDashboardPlot(container);
        if (plot != null) {
            DefaultCategoryDataset chartDataset = (DefaultCategoryDataset)plot.getDataset();
            chartDataset.clear();
        }
    }

    public void updateDashboardView(DashboardItem dashboardItem) {
        DashboardChartComposite chartComposite;
        DashboardViewConfiguration viewConfiguration;
        DashboardItemViewConfiguration viewConfig;
        CategoryPlot plot = this.getDashboardPlot((DashboardContainer)dashboardItem);
        if (plot != null && (viewConfig = (viewConfiguration = (chartComposite = this.getChartComposite((DashboardContainer)dashboardItem)).getViewContainer().getViewConfiguration()).getDashboardConfig(dashboardItem.getDashboardId())) != null) {
            chartComposite.getChart().getLegend().setVisible(viewConfig.isLegendVisible());
            plot.setDomainGridlinesVisible(viewConfig.isGridVisible());
            plot.setRangeGridlinesVisible(viewConfig.isGridVisible());
        }
        dashboardItem.getParent().layout(true, true);
    }

    private CategoryPlot getDashboardPlot(DashboardContainer container) {
        DashboardChartComposite chartComposite = this.getChartComposite(container);
        JFreeChart chart = chartComposite.getChart();
        return chart.getCategoryPlot();
    }
}

