/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.security;

import com.vertica.support.ILogger;
import com.vertica.support.security.ISecurityContext;
import com.vertica.support.security.SimbaCredentials;
import com.vertica.support.security.SimbaSecurityContext;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import sun.security.jgss.GSSUtil;

class SimbaAuthenticatedCredentials
extends SimbaCredentials {
    private final ILogger m_logger = null;
    private final GSSContext m_remoteContext;
    private final GSSManager m_gssManager;
    private Subject m_subject = null;

    public SimbaAuthenticatedCredentials(ILogger iLogger, GSSManager gSSManager, GSSContext gSSContext) {
        this.m_remoteContext = gSSContext;
        this.m_gssManager = gSSManager;
    }

    GSSCredential getCredentialHandle() throws GSSException {
        return this.m_remoteContext.getDelegCred();
    }

    public ISecurityContext getSecurityContext(String string) throws Exception {
        return new SimbaSecurityContext(this, this.m_logger, string, this.m_gssManager);
    }

    public String getName() throws Exception {
        return ((Object)this.m_remoteContext.getSrcName()).toString();
    }

    public Object executeAs(PrivilegedAction privilegedAction) throws Exception {
        if (null == this.m_subject) {
            GSSCredential gSSCredential;
            try {
                gSSCredential = this.m_remoteContext.getDelegCred();
            }
            catch (GSSException gSSException) {
                gSSCredential = null;
            }
            this.m_subject = GSSUtil.getSubject(this.m_remoteContext.getSrcName(), gSSCredential);
        }
        return Subject.doAsPrivileged(this.m_subject, privilegedAction, null);
    }
}

