/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc4;

import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.impl.DSIEmptyResultSet;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.ExecutionResult;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.jdbc4.S4ForwardResultSet;
import com.vertica.jdbc.jdbc4.S4UpdatableForwardResultSet;
import com.vertica.jdbc.jdbc4.utilities.WrapperUtilities;
import com.vertica.support.LogUtilities;
import com.vertica.utilities.JDBCVersion;
import java.sql.ResultSet;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S4Statement
extends SStatement {
    public S4Statement(IStatement iStatement, SConnection sConnection, int n) {
        super(iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC4;
    }

    @Override
    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        SForwardResultSet sForwardResultSet = null;
        sForwardResultSet = this.createsUpdatableResults() ? new S4UpdatableForwardResultSet(this, (IResultSet)executionResult.getResult(), this.getLogger()) : new S4ForwardResultSet(this, (IResultSet)executionResult.getResult(), this.getLogger());
        sForwardResultSet.setFetchSize(this.getFetchSize());
        return sForwardResultSet;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            S4ForwardResultSet s4ForwardResultSet = null;
            s4ForwardResultSet = new S4ForwardResultSet(this, new DSIEmptyResultSet(), this.getLogger());
            return s4ForwardResultSet;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return null == this.m_statement || null == this.getParentConnection();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        this.checkIfOpen();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), bl);
        this.checkIfOpen();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }
}

