/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnection;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.jdbc.VerticaJdbc3ConnectionHandle;
import com.vertica.jdbc.VerticaJdbc3ConnectionImpl;
import com.vertica.jdbc.VerticaJdbc3PreparedStatementImpl;
import com.vertica.jdbc.VerticaJdbc3StatementImpl;
import com.vertica.jdbc.VerticaJdbc4ConnectionHandle;
import com.vertica.jdbc.VerticaJdbc4ConnectionImpl;
import com.vertica.jdbc.VerticaJdbc4PreparedStatementImpl;
import com.vertica.jdbc.VerticaJdbc4StatementImpl;
import com.vertica.jdbc.common.SCallableStatement;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SConnectionHandle;
import com.vertica.jdbc.common.SPooledConnection;
import com.vertica.jdbc.common.SPreparedStatement;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.hybrid.HybridJDBCObjectFactory;
import com.vertica.jdbc.jdbc3.S3Connection;
import com.vertica.jdbc.jdbc4.S4Connection;
import com.vertica.jdbc.kv.VerticaJdbc4RoutableConnectionImpl;
import com.vertica.utilities.JDBCVersion;
import java.sql.SQLException;
import javax.sql.PooledConnection;

final class VJDBCObjectFactory
extends HybridJDBCObjectFactory {
    private final boolean m_isJdbc3;

    protected VJDBCObjectFactory(JDBCVersion jDBCVersion) {
        super(jDBCVersion);
        this.m_isJdbc3 = jDBCVersion == JDBCVersion.JDBC3;
    }

    protected SCallableStatement createCallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        return super.createCallableStatement(string, iStatement, sConnection, n);
    }

    protected SConnection createConnection(IConnection iConnection, String string) throws SQLException {
        boolean bl = ((VConnection)iConnection).getEnableRoutableQueries();
        return this.m_isJdbc3 ? new VerticaJdbc3ConnectionImpl(iConnection, string) : (bl ? new VerticaJdbc4RoutableConnectionImpl(iConnection, string) : new VerticaJdbc4ConnectionImpl(iConnection, string));
    }

    protected SPreparedStatement createPreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        return this.m_isJdbc3 ? new VerticaJdbc3PreparedStatementImpl(string, iStatement, (S3Connection)sConnection, n) : new VerticaJdbc4PreparedStatementImpl(string, iStatement, (S4Connection)sConnection, n);
    }

    protected SStatement createStatement(IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        return this.m_isJdbc3 ? new VerticaJdbc3StatementImpl(iStatement, (S3Connection)sConnection, n) : new VerticaJdbc4StatementImpl(iStatement, (S4Connection)sConnection, n);
    }

    protected PooledConnection createPooledConnection(SConnection sConnection) throws SQLException {
        return super.createPooledConnection(sConnection);
    }

    protected SConnectionHandle createConnectionHandle(SConnection sConnection, SPooledConnection sPooledConnection) throws SQLException {
        return this.m_isJdbc3 ? new VerticaJdbc3ConnectionHandle(sConnection, sPooledConnection) : new VerticaJdbc4ConnectionHandle(sConnection, sPooledConnection);
    }
}

