/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import liquibase.pro.packaged.aA;
import liquibase.pro.packaged.aG;
import liquibase.pro.packaged.aL;
import liquibase.pro.packaged.aU;
import liquibase.pro.packaged.ak;
import liquibase.pro.packaged.as;
import liquibase.pro.packaged.au;
import liquibase.pro.packaged.av;
import liquibase.pro.packaged.aw;
import liquibase.pro.packaged.bF;
import liquibase.pro.packaged.bS;
import liquibase.pro.packaged.bb;
import liquibase.pro.packaged.bi;
import liquibase.pro.packaged.bj;
import liquibase.pro.packaged.bl;

public abstract class aK
extends aL {
    protected final aU _ioContext$2098a162;
    protected boolean _closed;
    protected int _inputPtr;
    protected int _inputEnd;
    protected long _currInputProcessed;
    protected int _currInputRow = 1;
    protected int _currInputRowStart;
    protected long _tokenInputTotal;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol;
    protected bl _parsingContext;
    protected aA _nextToken;
    protected final bS _textBuffer;
    protected char[] _nameCopyBuffer;
    protected boolean _nameCopied;
    protected bF _byteArrayBuilder;
    protected byte[] _binaryValue;
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    protected boolean _numberNegative;
    protected int _intLength;
    protected int _fractLength;
    protected int _expLength;

    protected aK(aU object, int n2) {
        super(n2);
        this._ioContext$2098a162 = object;
        this._textBuffer = ((aU)object).constructTextBuffer();
        object = av.STRICT_DUPLICATE_DETECTION.enabledIn(n2) ? bj.rootDetector(this) : null;
        this._parsingContext = bl.createRootContext((bj)object);
    }

    @Override
    public aG version() {
        return bi.VERSION;
    }

    @Override
    public Object getCurrentValue() {
        return this._parsingContext.getCurrentValue();
    }

    @Override
    public void setCurrentValue(Object object) {
        this._parsingContext.setCurrentValue(object);
    }

    @Override
    public au enable(av av2) {
        this._features |= av2.getMask();
        if (av2 == av.STRICT_DUPLICATE_DETECTION && this._parsingContext.getDupDetector() == null) {
            this._parsingContext = this._parsingContext.withDupDetector(bj.rootDetector(this));
        }
        return this;
    }

    @Override
    public au disable(av av2) {
        this._features &= ~av2.getMask();
        if (av2 == av.STRICT_DUPLICATE_DETECTION) {
            this._parsingContext = this._parsingContext.withDupDetector(null);
        }
        return this;
    }

    @Override
    @Deprecated
    public au setFeatureMask(int n2) {
        int n3 = this._features ^ n2;
        if (n3 != 0) {
            this._features = n2;
            this._checkStdFeatureChanges(n2, n3);
        }
        return this;
    }

    @Override
    public au overrideStdFeatures(int n2, int n3) {
        int n4 = this._features;
        if ((n3 = n4 ^ (n2 = n4 & ~n3 | n2 & n3)) != 0) {
            this._features = n2;
            this._checkStdFeatureChanges(n2, n3);
        }
        return this;
    }

    protected void _checkStdFeatureChanges(int n2, int n3) {
        int n4 = av.STRICT_DUPLICATE_DETECTION.getMask();
        if ((n3 & n4) != 0 && (n2 & n4) != 0) {
            if (this._parsingContext.getDupDetector() == null) {
                this._parsingContext = this._parsingContext.withDupDetector(bj.rootDetector(this));
                return;
            }
            this._parsingContext = this._parsingContext.withDupDetector(null);
        }
    }

    @Override
    public String getCurrentName() {
        bl bl2;
        if ((this._currToken == aA.START_OBJECT || this._currToken == aA.START_ARRAY) && (bl2 = this._parsingContext.getParent()) != null) {
            return bl2.getCurrentName();
        }
        return this._parsingContext.getCurrentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        bl bl2 = this._parsingContext;
        if (this._currToken == aA.START_OBJECT || this._currToken == aA.START_ARRAY) {
            bl2 = bl2.getParent();
        }
        try {
            bl2.setCurrentName(string);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public void close() {
        if (!this._closed) {
            this._inputPtr = Math.max(this._inputPtr, this._inputEnd);
            this._closed = true;
            try {
                this._closeInput();
                return;
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public bl getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public as getTokenLocation() {
        return new as(this._getSourceReference(), -1L, this.getTokenCharacterOffset(), this.getTokenLineNr(), this.getTokenColumnNr());
    }

    @Override
    public as getCurrentLocation() {
        int n2 = this._inputPtr - this._currInputRowStart + 1;
        return new as(this._getSourceReference(), -1L, this._currInputProcessed + (long)this._inputPtr, this._currInputRow, n2);
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == aA.VALUE_STRING) {
            return true;
        }
        if (this._currToken == aA.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    @Override
    public byte[] getBinaryValue(ak ak2) {
        if (this._binaryValue == null) {
            if (this._currToken != aA.VALUE_STRING) {
                this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING, can not access as binary");
            }
            bF bF2 = this._getByteArrayBuilder();
            aK aK2 = this;
            aK2._decodeBase64(aK2.getText(), bF2, ak2);
            this._binaryValue = bF2.toByteArray();
        }
        return this._binaryValue;
    }

    public long getTokenCharacterOffset() {
        return this._tokenInputTotal;
    }

    public int getTokenLineNr() {
        return this._tokenInputRow;
    }

    public int getTokenColumnNr() {
        int n2 = this._tokenInputCol;
        if (n2 < 0) {
            return n2;
        }
        return n2 + 1;
    }

    protected abstract void _closeInput();

    protected void _releaseBuffers() {
        this._textBuffer.releaseBuffers();
        char[] cArray = this._nameCopyBuffer;
        if (this._nameCopyBuffer != null) {
            this._nameCopyBuffer = null;
            this._ioContext$2098a162.releaseNameCopyBuffer(cArray);
        }
    }

    @Override
    protected void _handleEOF() {
        if (!this._parsingContext.inRoot()) {
            String string = this._parsingContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", string, this._parsingContext.getStartLocation(this._getSourceReference())), null);
        }
    }

    protected final int _eofAsNextChar() {
        this._handleEOF();
        return -1;
    }

    public bF _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new bF();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected final aA reset(boolean bl2, int n2, int n3, int n4) {
        if (n3 <= 0 && n4 <= 0) {
            return this.resetInt(bl2, n2);
        }
        return this.resetFloat(bl2, n2, n3, n4);
    }

    protected final aA resetInt(boolean bl2, int n2) {
        this._numberNegative = bl2;
        this._intLength = n2;
        this._fractLength = 0;
        this._expLength = 0;
        this._numTypesValid = 0;
        return aA.VALUE_NUMBER_INT;
    }

    protected final aA resetFloat(boolean bl2, int n2, int n3, int n4) {
        this._numberNegative = bl2;
        this._intLength = n2;
        this._fractLength = n3;
        this._expLength = n4;
        this._numTypesValid = 0;
        return aA.VALUE_NUMBER_FLOAT;
    }

    protected final aA resetAsNaN(String string, double d2) {
        this._textBuffer.resetWithString(string);
        this._numberDouble = d2;
        this._numTypesValid = 8;
        return aA.VALUE_NUMBER_FLOAT;
    }

    @Override
    public boolean isNaN() {
        if (this._currToken == aA.VALUE_NUMBER_FLOAT && (this._numTypesValid & 8) != 0) {
            double d2 = this._numberDouble;
            return Double.isNaN(d2) || Double.isInfinite(d2);
        }
        return false;
    }

    @Override
    public Number getNumberValue() {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == aA.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._numberBigInt;
            }
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._numberDouble;
    }

    @Override
    public aw getNumberType() {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == aA.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return aw.INT;
            }
            if ((this._numTypesValid & 2) != 0) {
                return aw.LONG;
            }
            return aw.BIG_INTEGER;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return aw.BIG_DECIMAL;
        }
        return aw.DOUBLE;
    }

    @Override
    public int getIntValue() {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                return this._parseIntValue();
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public long getLongValue() {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    @Override
    public float getFloatValue() {
        return (float)this.getDoubleValue();
    }

    @Override
    public double getDoubleValue() {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    @Override
    public BigDecimal getDecimalValue() {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._numberBigDecimal;
    }

    protected void _parseNumericValue(int n2) {
        if (this._currToken == aA.VALUE_NUMBER_INT) {
            int n3 = this._intLength;
            if (n3 <= 9) {
                this._numberInt = n2 = this._textBuffer.contentsAsInt(this._numberNegative);
                this._numTypesValid = 1;
                return;
            }
            if (n3 <= 18) {
                long l2 = this._textBuffer.contentsAsLong(this._numberNegative);
                if (n3 == 10) {
                    if (this._numberNegative) {
                        if (l2 >= Integer.MIN_VALUE) {
                            this._numberInt = (int)l2;
                            this._numTypesValid = 1;
                            return;
                        }
                    } else if (l2 <= Integer.MAX_VALUE) {
                        this._numberInt = (int)l2;
                        this._numTypesValid = 1;
                        return;
                    }
                }
                this._numberLong = l2;
                this._numTypesValid = 2;
                return;
            }
            this._parseSlowInt(n2);
            return;
        }
        if (this._currToken == aA.VALUE_NUMBER_FLOAT) {
            this._parseSlowFloat(n2);
            return;
        }
        this._reportError("Current token (%s) not numeric, can not use numeric value accessors", (Object)this._currToken);
    }

    protected int _parseIntValue() {
        if (this._currToken == aA.VALUE_NUMBER_INT && this._intLength <= 9) {
            int n2;
            this._numberInt = n2 = this._textBuffer.contentsAsInt(this._numberNegative);
            this._numTypesValid = 1;
            return n2;
        }
        this._parseNumericValue(1);
        if ((this._numTypesValid & 1) == 0) {
            this.convertNumberToInt();
        }
        return this._numberInt;
    }

    private void _parseSlowFloat(int n2) {
        try {
            if (n2 == 16) {
                this._numberBigDecimal = this._textBuffer.contentsAsDecimal();
                this._numTypesValid = 16;
                return;
            }
            this._numberDouble = this._textBuffer.contentsAsDouble();
            this._numTypesValid = 8;
            return;
        }
        catch (NumberFormatException numberFormatException) {
            aK aK2 = this;
            this._wrapError("Malformed numeric value (" + aK2._longNumberDesc(aK2._textBuffer.contentsAsString()) + ")", numberFormatException);
            return;
        }
    }

    private void _parseSlowInt(int n2) {
        String string = this._textBuffer.contentsAsString();
        try {
            int n3 = this._intLength;
            char[] cArray = this._textBuffer.getTextBuffer();
            int n4 = this._textBuffer.getTextOffset();
            if (this._numberNegative) {
                ++n4;
            }
            if (bb.inLongRange(cArray, n4, n3, this._numberNegative)) {
                this._numberLong = Long.parseLong(string);
                this._numTypesValid = 2;
                return;
            }
            if (n2 == 1 || n2 == 2) {
                this._reportTooLongInt(n2, string);
            }
            if (n2 == 8 || n2 == 32) {
                this._numberDouble = bb.parseDouble(string);
                this._numTypesValid = 8;
                return;
            }
            this._numberBigInt = new BigInteger(string);
            this._numTypesValid = 4;
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this._wrapError("Malformed numeric value (" + this._longNumberDesc(string) + ")", numberFormatException);
            return;
        }
    }

    protected void _reportTooLongInt(int n2, String string) {
        string = this._longIntegerDesc(string);
        this._reportError("Numeric value (%s) out of range of %s", string, n2 == 2 ? "long" : "int");
    }

    protected void convertNumberToInt() {
        if ((this._numTypesValid & 2) != 0) {
            int n2 = (int)this._numberLong;
            if ((long)n2 != this._numberLong) {
                this._reportError("Numeric value (" + this.getText() + ") out of range of int");
            }
            this._numberInt = n2;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_INT.compareTo(this._numberBigInt) > 0 || BI_MAX_INT.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigInt.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -2.147483648E9 || this._numberDouble > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this._numberBigDecimal) > 0 || BD_MAX_INT.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void convertNumberToLong() {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_LONG.compareTo(this._numberBigInt) > 0 || BI_MAX_LONG.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigInt.longValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -9.223372036854776E18 || this._numberDouble > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this._numberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void convertNumberToBigInteger() {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberBigInt = this._numberBigDecimal.toBigInteger();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected void convertNumberToDouble() {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberBigDecimal.doubleValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberBigInt.doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected void convertNumberToBigDecimal() {
        if ((this._numTypesValid & 8) != 0) {
            this._numberBigDecimal = bb.parseBigDecimal(this.getText());
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberBigInt);
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected void _reportMismatchedEndMarker(int n2, char c2) {
        bl bl2 = this.getParsingContext();
        this._reportError(String.format("Unexpected close marker '%s': expected '%c' (for %s starting at %s)", Character.valueOf((char)n2), Character.valueOf(c2), bl2.typeDesc(), bl2.getStartLocation(this._getSourceReference())));
    }

    protected char _decodeEscaped() {
        throw new UnsupportedOperationException();
    }

    protected final int _decodeBase64Escape(ak ak2, int n2, int n3) {
        if (n2 != 92) {
            throw this.reportInvalidBase64Char(ak2, n2, n3);
        }
        char c2 = this._decodeEscaped();
        n2 = c2;
        if (c2 <= ' ' && n3 == 0) {
            return -1;
        }
        int n4 = ak2.decodeBase64Char(n2);
        if (n4 < 0 && n4 != -2) {
            throw this.reportInvalidBase64Char(ak2, n2, n3);
        }
        return n4;
    }

    protected final int _decodeBase64Escape(ak ak2, char c2, int n2) {
        if (c2 != '\\') {
            throw this.reportInvalidBase64Char(ak2, c2, n2);
        }
        c2 = this._decodeEscaped();
        if (c2 <= ' ' && n2 == 0) {
            return -1;
        }
        int n3 = ak2.decodeBase64Char(c2);
        if (n3 < 0 && (n3 != -2 || n2 < 2)) {
            throw this.reportInvalidBase64Char(ak2, c2, n2);
        }
        return n3;
    }

    protected IllegalArgumentException reportInvalidBase64Char(ak ak2, int n2, int n3) {
        return this.reportInvalidBase64Char(ak2, n2, n3, null);
    }

    protected IllegalArgumentException reportInvalidBase64Char(ak object, int n2, int n3, String string) {
        object = n2 <= 32 ? String.format("Illegal white space character (code 0x%s) as character #%d of 4-char base64 unit: can only used between units", Integer.toHexString(n2), n3 + 1) : (((ak)object).usesPaddingChar(n2) ? "Unexpected padding character ('" + ((ak)object).getPaddingChar() + "') as character #" + (n3 + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(n2) || Character.isISOControl(n2) ? "Illegal character (code 0x" + Integer.toHexString(n2) + ") in base64 content" : "Illegal character '" + (char)n2 + "' (code 0x" + Integer.toHexString(n2) + ") in base64 content"));
        if (string != null) {
            object = (String)object + ": " + string;
        }
        return new IllegalArgumentException((String)object);
    }

    protected void _handleBase64MissingPadding(ak ak2) {
        this._reportError(ak2.missingPaddingMessage());
    }

    protected Object _getSourceReference() {
        if (av.INCLUDE_SOURCE_IN_LOCATION.enabledIn(this._features)) {
            return this._ioContext$2098a162.getSourceReference();
        }
        return null;
    }

    protected static int[] growArrayBy(int[] nArray, int n2) {
        if (nArray == null) {
            return new int[n2];
        }
        return Arrays.copyOf(nArray, nArray.length + n2);
    }

    @Deprecated
    protected void loadMoreGuaranteed() {
        if (!this.loadMore()) {
            this._reportInvalidEOF();
        }
    }

    @Deprecated
    protected boolean loadMore() {
        return false;
    }

    protected void _finishString() {
    }
}

