/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;

public class FireBirdSQLDialect
extends GenericSQLDialect {
    private static final String[] FB_BLOCK_HEADERS = new String[]{"EXECUTE BLOCK"};
    private static final String[][] FB_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}};
    private static final String[] DDL_KEYWORDS = new String[]{"CREATE", "ALTER", "DROP", "EXECUTE"};
    private static final String[] FIREBIRD_KEYWORDS = new String[]{"CURRENT_USER", "CURRENT_ROLE", "NCHAR", "VALUE"};

    public FireBirdSQLDialect() {
        super("Firebird", "firebird");
    }

    @NotNull
    public String[] getDDLKeywords() {
        return DDL_KEYWORDS;
    }

    public String[] getBlockHeaderStrings() {
        return FB_BLOCK_HEADERS;
    }

    public String[][] getBlockBoundStrings() {
        return FB_BEGIN_END_BLOCK;
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.turnFunctionIntoKeyword("TRUNCATE");
        this.addKeywords(Arrays.asList(FIREBIRD_KEYWORDS), DBPKeywordType.KEYWORD);
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean validIdentifierPart(char c, boolean quoted) {
        return super.validIdentifierPart(c, quoted) || c == '$';
    }

    protected String getStoredProcedureCallInitialClause(DBSProcedure proc) {
        return "select * from " + proc.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    public boolean supportsInsertAllDefaultValuesStatement() {
        return true;
    }
}

