/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client;

import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.auth.SMCredentials;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;

public abstract class AbstractRemoteClientConfiguration {
    public static final SMCredentialsProvider NO_AUTH_CREDENTIALS_MANAGER = new SMCredentialsProvider(){

        public SMCredentials getActiveUserCredentials() {
            return null;
        }
    };
    @NotNull
    protected final String apiUrl;
    @NotNull
    protected final SMCredentialsProvider credentialsProvider;

    protected AbstractRemoteClientConfiguration(@NotNull String apiUrl, @NotNull SMCredentialsProvider credentialsProvider) {
        this.apiUrl = Objects.requireNonNull(apiUrl, "DC api url is null");
        this.credentialsProvider = Objects.requireNonNull(credentialsProvider, "SM credentials provider is null");
    }

    @NotNull
    public String getApiUrl() {
        return this.apiUrl;
    }

    @NotNull
    public SMCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    protected static abstract class AbstractBuilder<BUILDER extends AbstractBuilder, CLIENT_CONFIG> {
        protected String apiUrl;
        protected SMCredentialsProvider credentialsProvider = NO_AUTH_CREDENTIALS_MANAGER;

        protected AbstractBuilder() {
        }

        public BUILDER from(@NotNull AbstractRemoteClientConfiguration originConfig) {
            this.apiUrl = originConfig.apiUrl;
            this.credentialsProvider = originConfig.credentialsProvider;
            return this.getThis();
        }

        public BUILDER setApiUrl(@NotNull String apiUrl) {
            this.apiUrl = apiUrl;
            return this.getThis();
        }

        public BUILDER setCredentialsProvider(@NotNull SMCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this.getThis();
        }

        public abstract CLIENT_CONFIG build();

        protected abstract BUILDER getThis();
    }
}

