/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client;

import com.dbeaver.remote.client.GsonUtils;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;

public abstract class AbstractRemoteClient {
    private static final MediaType JSON = MediaType.parse((String)"application/json");
    private static final Gson gson = GsonUtils.gsonBuilder().create();
    private final OkHttpClient httpClient;
    private final String apiUrl;

    public AbstractRemoteClient(String apiUrl, List<Interceptor> interceptors) {
        this(apiUrl, -1, -1, interceptors);
    }

    public AbstractRemoteClient(String apiUrl, int connectTimeout, int readTimeout, List<Interceptor> interceptors) {
        this.apiUrl = apiUrl;
        this.httpClient = this.buildClient(connectTimeout, readTimeout, interceptors);
    }

    @NotNull
    private OkHttpClient buildClient(int connectTimeout, int readTimeout, List<Interceptor> interceptors) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient().newBuilder();
        if (connectTimeout > 0) {
            httpClientBuilder.connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS);
        }
        if (readTimeout > 0) {
            httpClientBuilder.readTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
        }
        interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)httpClientBuilder).addInterceptor(arg_0));
        return httpClientBuilder.build();
    }

    protected OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    protected <T> T executeGetRequest(String endpointUrl, Type type) throws DBException {
        return this.executeGetRequest(endpointUrl, Map.of(), type);
    }

    protected <T> T executeGetRequest(String endpointUrl, Map<String, ?> parameters, Type type) throws DBException {
        HttpUrl url = this.buildUrl(endpointUrl, parameters);
        Request request = new Request.Builder().url(url).build();
        return this.executeRequest(request, type);
    }

    protected <T> T executeDeleteRequest(String endpointUrl, Type type) throws DBException {
        return this.executeDeleteRequest(endpointUrl, Map.of(), type);
    }

    protected <T> T executeDeleteRequest(String endpointUrl, Map<String, ?> parameters, Type type) throws DBException {
        HttpUrl url = this.buildUrl(endpointUrl, parameters);
        Request request = new Request.Builder().url(url).delete().build();
        return this.executeRequest(request, type);
    }

    protected <T> T executePostRequest(String endpointUrl, Object body, Type type) throws DBException {
        HttpUrl url = this.buildUrl(endpointUrl, Map.of());
        Request request = new Request.Builder().url(url).post(RequestBody.create((String)gson.toJson(body), (MediaType)JSON)).build();
        return this.executeRequest(request, type);
    }

    protected <T> T executePutRequest(String endpointUrl, Object body, Type type) throws DBException {
        HttpUrl url = this.buildUrl(endpointUrl, Map.of());
        Request request = new Request.Builder().url(url).put(RequestBody.create((MediaType)JSON, (String)gson.toJson(body))).build();
        return this.executeRequest(request, type);
    }

    protected HttpUrl buildUrl(String endpointUrl, Map<String, ?> parameters) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.apiUrl).newBuilder().addPathSegments(endpointUrl);
        parameters.forEach((paramName, value) -> {
            if (value == null) {
                return;
            }
            if (value.getClass().isArray()) {
                Object[] array;
                Object[] objectArray = array = (Object[])value;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object v = objectArray[n2];
                    urlBuilder.addQueryParameter(paramName, v.toString());
                    ++n2;
                }
            } else if (Collection.class.isAssignableFrom(value.getClass())) {
                Collection array = (Collection)value;
                for (Object v : array) {
                    urlBuilder.addQueryParameter(paramName, v.toString());
                }
            } else {
                urlBuilder.addQueryParameter(paramName, value.toString());
            }
        });
        return urlBuilder.build();
    }

    private <T> T executeRequest(Request request, Type type) throws DBException {
        Call call = this.httpClient.newCall(request);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Response response = call.execute();){
                if (!response.isSuccessful()) {
                    throw new DBException(response.body().string());
                }
                String jsonResponse = response.body().string();
                if (type == String.class) {
                    return (T)jsonResponse;
                }
                return (T)gson.fromJson(jsonResponse, type);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.handleRequestException(e);
            return null;
        }
    }

    protected static String buildEndpointUrl(String ... pathParts) {
        return String.join((CharSequence)"/", pathParts);
    }

    protected abstract void handleRequestException(Exception var1) throws DBException;
}

