/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.model;

import com.dbeaver.db.google.bigtable.exec.BigTableResultSet;
import com.dbeaver.db.google.bigtable.exec.BigTableScanStatement;
import com.dbeaver.db.google.bigtable.exec.BigTableSession;
import com.dbeaver.db.google.bigtable.model.BigTableColumnFamily;
import com.dbeaver.db.google.bigtable.model.BigTableDataSource;
import com.dbeaver.db.google.bigtable.model.BigTableInstance;
import com.dbeaver.db.google.bigtable.model.BigTableTableKeyAttribute;
import com.dbeaver.db.google.bigtable.model.BigTableTableKeyConstraint;
import com.dbeaver.ee.model.document.DBAbstractDocumentContainer;
import com.google.cloud.bigtable.admin.v2.models.ColumnFamily;
import com.google.cloud.bigtable.admin.v2.models.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class BigTableTable
extends DBAbstractDocumentContainer<BigTableDataSource>
implements DBPSaveableObject,
DBPSystemObject,
DBPRefreshableObject,
DBPQualifiedObject {
    private static final Log log = Log.getLog(BigTableTable.class);
    private final BigTableInstance instance;
    private final String tableId;
    private boolean persisted;
    private volatile Table tableMeta;
    private List<BigTableColumnFamily> attributes;
    private BigTableTableKeyAttribute keyAttribute;
    private BigTableTableKeyConstraint keyConstraint;

    public BigTableTable(BigTableInstance instance, String tableId) {
        super((DBPDataSource)instance.getDataSource());
        this.instance = instance;
        this.tableId = tableId;
        this.persisted = true;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.tableId;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.instance;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSystem() {
        return false;
    }

    @Property
    public Map<String, ?> getReplicationStatus(DBRProgressMonitor monitor) {
        return this.getTableMeta(monitor).getReplicationStatesByClusterId();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableMeta = null;
        return this;
    }

    public BigTableTableKeyAttribute getKeyAttribute() {
        if (this.keyAttribute == null) {
            this.keyAttribute = new BigTableTableKeyAttribute(this);
        }
        return this.keyAttribute;
    }

    public BigTableTableKeyConstraint getKeyConstraint() {
        if (this.keyConstraint == null) {
            this.keyConstraint = new BigTableTableKeyConstraint(this);
        }
        return this.keyConstraint;
    }

    Table getTableMeta(DBRProgressMonitor monitor) {
        if (this.tableMeta == null) {
            this.tableMeta = this.instance.getTableAdminClient().getTable(this.tableId);
        }
        return this.tableMeta;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    @NotNull
    public List<BigTableColumnFamily> getAttributes(@NotNull DBRProgressMonitor monitor) {
        if (this.attributes == null) {
            ArrayList<BigTableColumnFamily> result = new ArrayList<BigTableColumnFamily>();
            for (ColumnFamily attrDef : this.getTableMeta(monitor).getColumnFamilies()) {
                result.add(new BigTableColumnFamily(this, attrDef));
            }
            this.attributes = result;
        }
        return this.attributes;
    }

    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBCException {
        BigTableColumnFamily attr = (BigTableColumnFamily)DBUtils.findObject(this.getAttributes(monitor), (String)attributeName);
        return attr != null ? attr : super.getAttribute(monitor, attributeName);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return String.valueOf(this.instance.getId()) + "." + this.getName();
    }

    public String[] getSupportedFeatures() {
        return new String[]{"data.select", "data.count", "data.filter"};
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        DBCStatistics statistics = new DBCStatistics();
        long startTime = System.currentTimeMillis();
        session.getProgressMonitor().subTask("Read table '" + this.getName() + "' rows");
        BigTableScanStatement scanStatement = new BigTableScanStatement((BigTableSession)session, this, dataFilter);
        scanStatement.setLimit(firstRow, maxRows);
        scanStatement.setStatementSource(source);
        scanStatement.executeStatement();
        BigTableResultSet resultSet = scanStatement.openResultSet();
        dataReceiver.fetchStart(session, (DBCResultSet)resultSet, firstRow, maxRows);
        try {
            DBFetchProgress fetchProgress = new DBFetchProgress(session.getProgressMonitor());
            while (resultSet.nextRow()) {
                if (fetchProgress.isCanceled()) break;
                dataReceiver.fetchRow(session, (DBCResultSet)resultSet);
                fetchProgress.monitorRowFetch();
            }
            fetchProgress.dumpStatistics(statistics);
        }
        finally {
            dataReceiver.fetchEnd(session, (DBCResultSet)resultSet);
        }
        statistics.addExecuteTime(System.currentTimeMillis() - startTime);
        return statistics;
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        this.instance.getDataClient();
        return -1L;
    }
}

