/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.exec;

import com.dbeaver.db.google.bigtable.BigTableSQL;
import com.dbeaver.db.google.bigtable.exec.BigTableBaseStatement;
import com.dbeaver.db.google.bigtable.exec.BigTableResultSet;
import com.dbeaver.db.google.bigtable.exec.BigTableSession;
import com.dbeaver.db.google.bigtable.model.BigTableDataSource;
import com.dbeaver.db.google.bigtable.model.BigTableTable;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class BigTableScanStatement
extends BigTableBaseStatement {
    private final BigTableTable table;
    private DBDDataFilter dataFilter;
    private long offset;
    private long limit;
    private BigTableResultSet resultSet;

    public BigTableScanStatement(BigTableSession session, BigTableTable table, DBDDataFilter dataFilter) {
        super(session);
        this.table = table;
        this.dataFilter = dataFilter;
    }

    public BigTableTable getTable() {
        return this.table;
    }

    public String getQueryString() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ").append(this.table.getFullyQualifiedName(DBPEvaluationContext.UI));
        if (this.dataFilter != null && this.dataFilter.hasConditions()) {
            SQLUtils.appendConditionString((DBDDataFilter)this.dataFilter, (DBPDataSource)this.table.getDataSource(), null, (StringBuilder)sql, (boolean)true);
        }
        return sql.toString();
    }

    @Override
    public BigTableResultSet executeWithResults() throws DBCException {
        BigtableDataClient dataClient = ((BigTableSession)this.getSession()).getExecutionContext().getOwnerInstance().getDataClient();
        Query query = Query.create((String)this.table.getName());
        if (this.dataFilter != null && this.dataFilter.hasConditions()) {
            Filters.Filter queryFilter;
            StringBuilder sqlCondition = new StringBuilder();
            SQLUtils.appendConditionString((DBDDataFilter)this.dataFilter, (DBPDataSource)this.table.getDataSource(), null, (StringBuilder)sqlCondition, (boolean)true);
            if (sqlCondition.length() > 0 && (queryFilter = BigTableSQL.createQueryFilter((BigTableDataSource)this.table.getDataSource(), sqlCondition.toString())) != null) {
                query.filter(queryFilter);
            }
        }
        if (this.getLimit() > 0L) {
            query.limit(this.getLimit());
        }
        ServerStream rows = dataClient.readRows(query);
        return new BigTableResultSet(this, (ServerStream<Row>)rows);
    }

    public boolean executeStatement() throws DBCException {
        this.resultSet = this.executeWithResults();
        return true;
    }

    public void addToBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public BigTableResultSet openResultSet() throws DBCException {
        return this.resultSet;
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public long getUpdateRowCount() {
        return -1L;
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public void close() {
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread == null) {
            throw new DBException("Mongo query cancel not implemented");
        }
        blockThread.interrupt();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public String getEntityName() {
        return this.table.getName();
    }
}

