/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumExternalTable;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class GreenplumExternalTableManager
extends PostgreTableManager {
    protected GreenplumExternalTable createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        GreenplumExternalTable externalTable = new GreenplumExternalTable((PostgreSchema)container);
        this.setNewObjectName(monitor, (DBSObject)((PostgreSchema)container), (DBSObject)externalTable);
        return externalTable;
    }

    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        GreenplumExternalTable table = (GreenplumExternalTable)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_table, table.generateDDL(monitor)));
    }

    protected String getCreateTableType(PostgreTableBase table) {
        return "EXTERNAL TABLE";
    }

    @Nullable
    public DBSObjectCache<PostgreTableContainer, PostgreTableBase> getObjectsCache(PostgreTableBase object) {
        return ((PostgreTableContainer)object.getContainer()).getSchema().getTableCache();
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)this.createDeleteAction((PostgreTableBase)command.getObject(), options));
    }

    <T extends PostgreTableBase> SQLDatabasePersistAction createDeleteAction(T table, Map<String, Object> options) {
        StringBuilder dropTableScript = new StringBuilder("DROP EXTERNAL TABLE ").append(table.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE" : "");
        return new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, dropTableScript.toString());
    }
}

