/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.keyspaces;

import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.utils.CommonUtils;

public class AWSCloudKeyspacesEndpoint
extends AWSCloudAbstractInstance {
    public AWSCloudKeyspacesEndpoint(AWSCloudSession session, AWSCloudZone region) {
        super(session, region);
    }

    @NotNull
    public String getNodeId() {
        return this.getAwsRegionId();
    }

    @NotNull
    public String getNodeName() {
        return this.getZone().getName();
    }

    @Nullable
    public String getInstanceEndpoint() {
        return "cassandra." + this.getAwsRegionId() + ".amazonaws.com:" + this.getKeyspacesPortNumber();
    }

    public int getKeyspacesPortNumber() {
        int defPort = 9142;
        try {
            defPort = CommonUtils.toInt((Object)AWSCloudService.KEYSPACES.getInstanceDriver().getDefaultPort());
        }
        catch (DBException dBException) {}
        return defPort;
    }

    @Override
    protected void setDataSourceConfiguration(DBPConnectionConfiguration configuration) throws DBException {
        configuration.setHostName(this.getAwsRegionId());
        configuration.setHostPort(String.valueOf(this.getKeyspacesPortNumber()));
        configuration.setAuthModelId("iam_keyspaces");
        configuration.setAuthProperty("iam.region", this.getZone().getZoneId());
    }

    @Override
    protected AWSCloudService getCloudService() {
        return AWSCloudService.KEYSPACES;
    }

    @Override
    protected String getInstanceARN() {
        return "arn:aws:keyspaces:" + this.getAwsRegionId();
    }

    @Override
    protected String getExternalLink() {
        return this.getLinkPrefix();
    }
}

