/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.dynamodb;

import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import software.amazon.awssdk.services.dynamodb.model.Endpoint;

public class AWSCloudDynamoDBEndpoint
extends AWSCloudAbstractInstance {
    private final Endpoint endpoint;

    public AWSCloudDynamoDBEndpoint(AWSCloudSession session, AWSCloudZone region, Endpoint endpoint) {
        super(session, region);
        this.endpoint = endpoint;
    }

    @NotNull
    public String getNodeId() {
        return this.endpoint.address();
    }

    @NotNull
    public String getNodeName() {
        return this.getZone().getName();
    }

    @Nullable
    public String getInstanceEndpoint() {
        return this.endpoint.address();
    }

    @Override
    protected void setDataSourceConfiguration(DBPConnectionConfiguration configuration) throws DBException {
        configuration.setDatabaseName(this.endpoint.address());
        configuration.setHostName(this.endpoint.address());
        configuration.setProviderProperty("regionName", this.getZone().getZoneId());
        configuration.setAuthModelId("iam_simple");
        configuration.setAuthProperty("iam.region", this.getZone().getZoneId());
    }

    @Override
    protected AWSCloudService getCloudService() {
        return AWSCloudService.DYNAMODB;
    }

    @Override
    protected String getInstanceARN() {
        return this.endpoint.address();
    }

    @Override
    protected String getExternalLink() {
        return this.getLinkPrefix();
    }
}

