/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudDataSourceOrigin;
import com.dbeaver.cloud.aws.AWSCloudUtils;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudProvider;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.registry.CPCloudConfigurationListener;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationRegistry;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.Arrays;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.utils.CommonUtils;

public class AWSCloudProvider
implements CPCloudProvider,
CPCloudConfigurationListener {
    private static final Log log = Log.getLog(AWSCloudProvider.class);
    private AWSCloud[] allClouds;

    public AWSCloudProvider() {
        CPCloudConfigurationRegistry.getInstance().addConfigurationChangeListener((CPCloudConfigurationListener)this, true);
    }

    @NotNull
    public String getCloudProviderId() {
        return "aws";
    }

    @NotNull
    public synchronized AWSCloud[] getAvailableClouds() {
        if (this.allClouds == null) {
            CPCloudConfigurationProvider configurationProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(this.getCloudProviderId());
            CPCloudConfiguration[] configurations = new CPCloudConfiguration[]{};
            if (configurationProvider != null) {
                configurations = configurationProvider.getCloudConfigurations();
            }
            this.allClouds = (AWSCloud[])Arrays.stream(configurations).filter(cfg -> cfg instanceof AWSCloudConfiguration).map(cfg -> new AWSCloud(this, (AWSCloudConfiguration)cfg)).toArray(AWSCloud[]::new);
        }
        return this.allClouds;
    }

    public DBPDataSourceOrigin createDataSourceOrigin(@NotNull CPCloud<?, ?> cloud, CPCloudZone zone, Map<String, Object> configuration) {
        String resourceId = CommonUtils.toString((Object)configuration.get("aws-resource"));
        return new AWSCloudDataSourceOrigin(AWSCloudUtils.getAwsCloudProvider(), (AWSCloud)cloud, (AWSCloudZone)zone, resourceId);
    }

    public AWSCloud createCloudInstance(AWSCloudConfiguration configuration) {
        return new AWSCloud(this, configuration);
    }

    public void handleCloudConfigurationChange() {
        this.allClouds = null;
    }
}

