/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudDataSourceOrigin;
import com.dbeaver.cloud.aws.AWSCloudDataSourceStorage;
import com.dbeaver.cloud.aws.AWSCloudExplorer;
import com.dbeaver.cloud.aws.AWSCloudProvider;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudUtils;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudSessionManager;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSessionProviderService;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;

public class AWSCloud
implements CPCloud<AWSCloudZone, AWSCloudSession>,
CPCloudSessionManager<AWSCloudSession, AWSCloudZone> {
    private static final Log log = Log.getLog(AWSCloud.class);
    private final AWSCloudProvider provider;
    private final AWSCloudConfiguration configuration;
    private final AWSCloudDataSourceStorage dataSourceStorage;

    AWSCloud(AWSCloudProvider provider, AWSCloudConfiguration configuration) {
        this.provider = provider;
        this.configuration = configuration;
        this.dataSourceStorage = new AWSCloudDataSourceStorage(this);
    }

    @NotNull
    public AWSCloudZone[] getAllZones() {
        return (AWSCloudZone[])Region.regions().stream().filter(region -> !region.isGlobalRegion()).map(AWSCloudZone::valueOf).toArray(AWSCloudZone[]::new);
    }

    @NotNull
    public AWSCloudConfiguration getCloudConfiguration() {
        return this.configuration;
    }

    @NotNull
    public String getCloudId() {
        return CommonUtils.notEmpty((String)this.configuration.getCloudId());
    }

    @NotNull
    public String getName() {
        return CommonUtils.notEmpty((String)this.configuration.getCloudName());
    }

    @NotNull
    public AWSCloudExplorer createExplorer(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session) {
        return new AWSCloudExplorer(this, session);
    }

    public boolean isDatabaseServiceSupported(String serviceId) {
        return true;
    }

    public AWSCloudSession getActiveSession() {
        try {
            return (AWSCloudSession)DBWorkbench.getPlatform().getWorkspace().getAuthContext().getSpaceSession((DBRProgressMonitor)new VoidProgressMonitor(), (SMAuthSpace)this, false);
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    public String testConnection(DBRProgressMonitor monitor) throws DBException {
        SMSessionProviderService sessionProviderService = (SMSessionProviderService)DBWorkbench.getService(SMSessionProviderService.class);
        if (sessionProviderService == null) {
            throw new DBException("Can't obtain session provider");
        }
        monitor.beginTask("Connecting to AWS Cloud", 1);
        Throwable throwable = null;
        Object var4_5 = null;
        try (AWSCloudSession session = (AWSCloudSession)DBWorkbench.getPlatform().getWorkspace().getAuthContext().getSpaceSession(monitor, (SMAuthSpace)this, true);){
            GetCallerIdentityResponse callerIdentity = this.readGetCallerIdentity(monitor, session);
            monitor.done();
            return callerIdentity.arn();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String refreshSession(DBRProgressMonitor monitor) throws DBException {
        AWSCloudSession session = this.getActiveSession();
        if (session == null) {
            return "No active session, nothing to refresh";
        }
        if (session.getIamCredentials().refreshSession(monitor, null)) {
            return "SSO re-authenticated";
        }
        return "Nothing to refresh";
    }

    public void closeSession(DBRProgressMonitor monitor) throws DBException {
        AWSCloudSession session = this.getActiveSession();
        if (session != null) {
            session.getIamCredentials().closeSession(monitor);
        }
    }

    GetCallerIdentityResponse readGetCallerIdentity(DBRProgressMonitor monitor, AWSCloudSession session) throws DBCException {
        monitor.subTask("Ping STS service");
        StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(Region.AWS_GLOBAL)).credentialsProvider(session.getIamCredentials().getAuthCredentialsProvider(monitor))).build();
        return stsClient.getCallerIdentity();
    }

    AWSCloudDataSourceStorage getDataSourceStorage() {
        return this.dataSourceStorage;
    }

    @NotNull
    public AWSCloudZone[] getCloudAssignedZones() {
        ArrayList<AWSCloudZone> awsDefaultZones = new ArrayList<AWSCloudZone>();
        String[] stringArray = this.configuration.getDefaultRegions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String regionId = stringArray[n2];
            awsDefaultZones.add(AWSCloudZone.valueOf(Region.of((String)regionId)));
            ++n2;
        }
        return awsDefaultZones.toArray(new AWSCloudZone[0]);
    }

    DBPDataSourceOrigin createOrigin(AWSCloudZone zone, String resourceId) {
        return new AWSCloudDataSourceOrigin(AWSCloudUtils.getAwsCloudProvider(), this, zone, resourceId);
    }

    public String toString() {
        return "AWS Cloud (" + this.configuration.getCloudId() + ")";
    }

    public boolean equals(Object obj) {
        return obj instanceof AWSCloud && ((AWSCloud)obj).getCloudId().equals(this.getCloudId());
    }
}

