/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase.model;

import com.couchbase.client.java.cluster.AuthDomain;
import com.couchbase.client.java.cluster.User;
import com.couchbase.client.java.cluster.UserRole;
import com.dbeaver.db.couchbase.model.CouchbaseDataSource;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CouchbaseUser
implements DBAUser {
    private static final Log log = Log.getLog(CouchbaseUser.class);
    private final CouchbaseDataSource dataSource;
    private User user;

    public CouchbaseUser(CouchbaseDataSource dataSource, User user) {
        this.dataSource = dataSource;
        this.user = user;
    }

    @NotNull
    public CouchbaseDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.user.name();
    }

    @Property(viewable=true, editable=true, order=2)
    public String getUserId() {
        return this.user.userId();
    }

    @Property(viewable=true, editable=true, order=3)
    public AuthDomain getDomain() {
        return this.user.domain();
    }

    @Property(viewable=true, editable=true, order=4)
    public List<String> getRoles() {
        ArrayList<String> roleList = new ArrayList<String>();
        UserRole[] userRoleArray = this.user.roles();
        int n = userRoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            UserRole role = userRoleArray[n2];
            if (role.bucket() == null) {
                roleList.add(role.role());
            } else {
                roleList.add(String.valueOf(role.role()) + "@" + role.bucket());
            }
            ++n2;
        }
        return roleList;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return true;
    }
}

