/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.dc.client.model.user;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jkiss.code.NotNull;

public class DCUserUpdateCredentialsRequest {
    @NotNull
    private final String authProviderId;
    @NotNull
    private final Map<String, Object> credentials;

    private DCUserUpdateCredentialsRequest(@NotNull String authProviderId, @NotNull Map<String, Object> credentials) {
        this.authProviderId = Objects.requireNonNull(authProviderId, "The auth provider id is null");
        this.credentials = credentials;
    }

    @NotNull
    public String getAuthProviderId() {
        return this.authProviderId;
    }

    @NotNull
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    public static Builder builder(@NotNull String authProviderId) {
        return new Builder(authProviderId);
    }

    public static final class Builder {
        private final String authProviderId;
        private Map<String, Object> credentials = Collections.emptyMap();

        private Builder(@NotNull String authProviderId) {
            this.authProviderId = authProviderId;
        }

        public Builder setCredentials(@NotNull Map<String, Object> credentials) {
            this.credentials = credentials;
            return this;
        }

        public DCUserUpdateCredentialsRequest build() {
            return new DCUserUpdateCredentialsRequest(this.authProviderId, this.credentials);
        }
    }
}

