/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.dc.client.model.session;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.security.SMSessionType;

public class DCSessionAuthRequest {
    @NotNull
    private final String authProviderId;
    @NotNull
    private final Map<String, Object> userCredentials;
    @NotNull
    private final String appSessionId;
    @NotNull
    private final Map<String, Object> sessionParameters;
    @NotNull
    private final SMSessionType sessionType;
    private final boolean anonymousAuth;

    private DCSessionAuthRequest(@NotNull String authProviderId, @NotNull Map<String, Object> userCredentials, @NotNull String appSessionId, @NotNull Map<String, Object> sessionParameters, @NotNull SMSessionType sessionType, boolean anonymousAuth) {
        this.authProviderId = Objects.requireNonNull(authProviderId, "The auth provider id is null");
        this.userCredentials = Objects.requireNonNull(userCredentials, "The user credentials id is null");
        this.appSessionId = appSessionId;
        this.sessionParameters = sessionParameters;
        this.sessionType = sessionType;
        this.anonymousAuth = anonymousAuth;
    }

    @NotNull
    public String getAuthProviderId() {
        return this.authProviderId;
    }

    @NotNull
    public Map<String, Object> getUserCredentials() {
        return this.userCredentials;
    }

    public boolean isAnonymousAuth() {
        return this.anonymousAuth;
    }

    @NotNull
    public String getAppSessionId() {
        return this.appSessionId;
    }

    @NotNull
    public Map<String, Object> getSessionParameters() {
        return this.sessionParameters;
    }

    @NotNull
    public SMSessionType getSessionType() {
        return this.sessionType;
    }

    public static Builder builder(String appSessionId) {
        return new Builder(appSessionId);
    }

    public static final class Builder {
        private final String appSessionId;
        private String authProviderId = "";
        private Map<String, Object> userCredentials = Collections.emptyMap();
        private Map<String, Object> sessionParameters = Collections.emptyMap();
        private boolean anonymousAuth = false;
        private SMSessionType sessionType;

        private Builder(String appSessionId) {
            this.appSessionId = appSessionId;
        }

        public Builder setAuthProviderId(String authProviderId) {
            this.authProviderId = authProviderId;
            return this;
        }

        public Builder setUserCredentials(Map<String, Object> userCredentials) {
            this.userCredentials = userCredentials;
            return this;
        }

        public Builder setSessionParameters(Map<String, Object> sessionParameters) {
            this.sessionParameters = sessionParameters;
            return this;
        }

        public Builder setSessionType(SMSessionType sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        public Builder setAnonymousAuth(boolean anonymousAuth) {
            this.anonymousAuth = anonymousAuth;
            return this;
        }

        public DCSessionAuthRequest build() {
            return new DCSessionAuthRequest(this.authProviderId, this.userCredentials, this.appSessionId, this.sessionParameters, this.sessionType, this.anonymousAuth);
        }
    }
}

