/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.dc.client.model.role;

import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class DCRoleCreateRequest {
    private final String roleId;
    private final String name;
    private final String description;
    private final String grantor;

    private DCRoleCreateRequest(@NotNull String roleId, @Nullable String name, @Nullable String description, @NotNull String grantor) {
        this.roleId = Objects.requireNonNull(roleId, "The role id is null");
        this.name = name;
        this.description = description;
        this.grantor = Objects.requireNonNull(grantor, "The grantor is null");
    }

    @NotNull
    public String getRoleId() {
        return this.roleId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public String getGrantor() {
        return this.grantor;
    }

    public static Builder builder(@NotNull String roleId, @NotNull String grantor) {
        return new Builder(roleId, grantor);
    }

    public static final class Builder {
        private final String roleId;
        private final String grantor;
        private String name;
        private String description;

        private Builder(@NotNull String roleId, @NotNull String grantor) {
            this.roleId = roleId;
            this.grantor = grantor;
        }

        public Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public DCRoleCreateRequest build() {
            return new DCRoleCreateRequest(this.roleId, this.name, this.description, this.grantor);
        }
    }
}

