/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.dc.client.model.license;

import java.util.Date;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseType;

public class DCLicense {
    private final String licenseId;
    private final LMLicenseType licenseType;
    private final Date licenseIssueTime;
    private final Date licenseStartTime;
    private final Date licenseEndTime;
    private final long flags;
    private final String productId;
    private final String productVersion;
    private final String ownerId;
    private final String ownerCompany;
    private final String ownerName;
    private final String ownerEmail;

    private DCLicense(Builder builder) {
        this.licenseId = builder.licenseId;
        this.licenseType = builder.licenseType;
        this.licenseIssueTime = builder.licenseIssueTime;
        this.licenseStartTime = builder.licenseStartTime;
        this.licenseEndTime = builder.licenseEndTime;
        this.flags = builder.flags;
        this.productId = builder.productId;
        this.productVersion = builder.productVersion;
        this.ownerId = builder.ownerId;
        this.ownerCompany = builder.ownerCompany;
        this.ownerName = builder.ownerName;
        this.ownerEmail = builder.ownerEmail;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public LMLicenseType getLicenseType() {
        return this.licenseType;
    }

    public Date getLicenseIssueTime() {
        return this.licenseIssueTime;
    }

    public Date getLicenseStartTime() {
        return this.licenseStartTime;
    }

    public Date getLicenseEndTime() {
        return this.licenseEndTime;
    }

    public long getFlags() {
        return this.flags;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerCompany() {
        return this.ownerCompany;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public static DCLicense fromLMLicense(LMLicense license) {
        return new Builder(license.getLicenseId(), license.getLicenseType()).setLicenseStartTime(license.getLicenseStartTime()).setLicenseEndTime(license.getLicenseEndTime()).setLicenseIssueTime(license.getLicenseIssueTime()).setProductId(license.getProductId()).setFlags(license.getFlags()).setProductVersion(license.getProductVersion()).setOwnerCompany(license.getOwnerCompany()).setOwnerEmail(license.getOwnerEmail()).setOwnerName(license.getOwnerName()).setOwnerId(license.getOwnerId()).build();
    }

    public static LMLicense toLMLicense(DCLicense license) {
        return new LMLicense(license.getLicenseId(), license.getLicenseType(), license.getLicenseIssueTime(), license.getLicenseStartTime(), license.getLicenseEndTime(), license.getFlags(), license.getProductId(), license.getProductVersion(), license.getOwnerId(), license.getOwnerCompany(), license.getOwnerName(), license.getOwnerEmail());
    }

    public static final class Builder {
        private final String licenseId;
        private final LMLicenseType licenseType;
        private Date licenseIssueTime;
        private Date licenseStartTime;
        private Date licenseEndTime;
        private long flags;
        private String productId;
        private String productVersion;
        private String ownerId;
        private String ownerCompany;
        private String ownerName;
        private String ownerEmail;

        public Builder(String licenseId, LMLicenseType licenseType) {
            this.licenseId = licenseId;
            this.licenseType = licenseType;
        }

        public Builder setLicenseIssueTime(Date licenseIssueTime) {
            this.licenseIssueTime = licenseIssueTime;
            return this;
        }

        public Builder setLicenseStartTime(Date licenseStartTime) {
            this.licenseStartTime = licenseStartTime;
            return this;
        }

        public Builder setLicenseEndTime(Date licenseEndTime) {
            this.licenseEndTime = licenseEndTime;
            return this;
        }

        public Builder setFlags(long flags) {
            this.flags = flags;
            return this;
        }

        public Builder setProductId(String productId) {
            this.productId = productId;
            return this;
        }

        public Builder setProductVersion(String productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        public Builder setOwnerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public Builder setOwnerCompany(String ownerCompany) {
            this.ownerCompany = ownerCompany;
            return this;
        }

        public Builder setOwnerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public Builder setOwnerEmail(String ownerEmail) {
            this.ownerEmail = ownerEmail;
            return this;
        }

        public DCLicense build() {
            return new DCLicense(this);
        }
    }
}

