/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.utilities;

import com.simba.athena.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.athena.dsi.dataengine.utilities.Nullable;
import com.simba.athena.dsi.dataengine.utilities.Searchable;
import com.simba.athena.dsi.dataengine.utilities.TypeMetadata;
import com.simba.athena.dsi.dataengine.utilities.Updatable;
import com.simba.athena.dsi.exceptions.NumericOverflowException;
import com.simba.athena.support.exceptions.ErrorException;
import com.simba.athena.utilities.JDBCVersion;
import java.util.ArrayList;
import java.util.List;

public final class MetaDataFactory {
    private static int COLUMN_STRING_LENGTH = 128;
    private static int COLUMN_REMARKS_LENGTH = 254;
    private static int COLUMN_INTEGER_LENGTH = 10;
    private static int COLUMN_SMALLINT_LENGTH = 5;
    private static int NUM_COMMON_COLUMNS = 4;
    private static int NUM_COMMON_TABLE_COLUMNS = NUM_COMMON_COLUMNS - 1;
    private static int LENGTH_COMMON_TABLE_HEADER = 5;

    public static List<ColumnMetadata> createAttributeMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(21);
        MetaDataFactory.addCommonMetaData(arrayList);
        arrayList.remove(3);
        for (int i = 0; i < NUM_COMMON_TABLE_COLUMNS; ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)arrayList.get(i);
            String string = columnMetadata.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            string = "TYPE" + string;
            columnMetadata.setLabel(string);
            columnMetadata.setName(string);
        }
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createStringMetaDataColumn("ATTR_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("ATTR_TYPE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("ATTR_SIZE", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("DECIMAL_DIGITS", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("NUM_PREC_RADIX", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("NULLABLE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("ATTR_DEF", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATA_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATETIME_SUB", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("CHAR_OCTET_LENGTH", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("ORDINAL_POSITION", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("IS_NULLABLE", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("SCOPE_CATALOG", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("SCOPE_SCHEMA", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("SCOPE_TABLE", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("SOURCE_DATA_TYPE", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createClientInfoPropertiesMetadata() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(4);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createStringMetaDataColumn("NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columnMetadata.setSearchable(Searchable.PREDICATE_NONE);
            columnMetadata.setUpdatable(Updatable.READ_ONLY);
            arrayList.add(columnMetadata);
            ColumnMetadata columnMetadata2 = MetaDataFactory.createIntegerMetaDataColumn("MAX_LEN", Nullable.NO_NULLS);
            columnMetadata2.setSearchable(Searchable.PREDICATE_NONE);
            columnMetadata2.setUpdatable(Updatable.READ_ONLY);
            arrayList.add(columnMetadata2);
            ColumnMetadata columnMetadata3 = MetaDataFactory.createStringMetaDataColumn("DEFAULT_VALUE", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columnMetadata3.setSearchable(Searchable.PREDICATE_NONE);
            columnMetadata3.setUpdatable(Updatable.READ_ONLY);
            arrayList.add(columnMetadata3);
            ColumnMetadata columnMetadata4 = MetaDataFactory.createStringMetaDataColumn("DESCRIPTION", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columnMetadata4.setSearchable(Searchable.PREDICATE_NONE);
            columnMetadata4.setUpdatable(Updatable.READ_ONLY);
            arrayList.add(columnMetadata4);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createCatalogOnlyMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(1);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createStringMetaDataColumn("TABLE_CAT", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createColumnPrivilegesMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(8);
        MetaDataFactory.addCommonMetaData(arrayList);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createStringMetaDataColumn("GRANTOR", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("GRANTEE", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("PRIVILEGE", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("IS_GRANTABLE", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createColumnsMetaData(JDBCVersion jDBCVersion) {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(24);
        MetaDataFactory.addCommonMetaData(arrayList);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("TYPE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("COLUMN_SIZE", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("BUFFER_LENGTH", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("DECIMAL_DIGITS", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("NUM_PREC_RADIX", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("NULLABLE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("COLUMN_DEF", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATA_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATETIME_SUB", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("CHAR_OCTET_LENGTH", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("ORDINAL_POSITION", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("IS_NULLABLE", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("SCOPE_CATALOG", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("SCOPE_SCHEMA", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("SCOPE_TABLE", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("SOURCE_DATA_TYPE", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("IS_AUTOINCREMENT", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            if (JDBCVersion.JDBC41 == jDBCVersion || JDBCVersion.JDBC42 == jDBCVersion) {
                columnMetadata = MetaDataFactory.createStringMetaDataColumn("IS_GENERATEDCOLUMN", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
                arrayList.add(columnMetadata);
            }
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createForeignKeysMetaData() {
        String string;
        ColumnMetadata columnMetadata;
        int n;
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(14);
        MetaDataFactory.addCommonMetaData(arrayList);
        for (n = 0; n < NUM_COMMON_COLUMNS; ++n) {
            columnMetadata = (ColumnMetadata)arrayList.get(n);
            string = columnMetadata.getName();
            string = "PK" + string;
            columnMetadata.setLabel(string);
            columnMetadata.setName(string);
        }
        MetaDataFactory.addCommonMetaData(arrayList);
        for (n = NUM_COMMON_COLUMNS; n < 2 * NUM_COMMON_COLUMNS; ++n) {
            columnMetadata = (ColumnMetadata)arrayList.get(n);
            string = columnMetadata.getName();
            string = "FK" + string;
            columnMetadata.setLabel(string);
            columnMetadata.setName(string);
        }
        try {
            ColumnMetadata columnMetadata2 = MetaDataFactory.createShortMetaDataColumn("KEY_SEQ", Nullable.NO_NULLS);
            arrayList.add(columnMetadata2);
            columnMetadata2 = MetaDataFactory.createShortMetaDataColumn("UPDATE_RULE", Nullable.NULLABLE);
            arrayList.add(columnMetadata2);
            columnMetadata2 = MetaDataFactory.createShortMetaDataColumn("DELETE_RULE", Nullable.NULLABLE);
            arrayList.add(columnMetadata2);
            columnMetadata2 = MetaDataFactory.createStringMetaDataColumn("FK_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata2);
            columnMetadata2 = MetaDataFactory.createStringMetaDataColumn("PK_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata2);
            columnMetadata2 = MetaDataFactory.createShortMetaDataColumn("DEFERRABILITY", Nullable.NO_NULLS);
            arrayList.add(columnMetadata2);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createFunctionsMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(8);
        MetaDataFactory.addCommonMetaData(arrayList);
        arrayList.remove(NUM_COMMON_TABLE_COLUMNS);
        for (int i = 0; i < NUM_COMMON_TABLE_COLUMNS; ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)arrayList.get(i);
            String string = columnMetadata.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            string = "FUNCTION" + string;
            columnMetadata.setLabel(string);
            columnMetadata.setName(string);
        }
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("FUNCTION_TYPE", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("SPECIFIC_NAME", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createFunctionColumnsMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(13);
        MetaDataFactory.addCommonMetaData(arrayList);
        for (int i = 0; i < NUM_COMMON_TABLE_COLUMNS; ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)arrayList.get(i);
            String string = columnMetadata.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            string = "FUNCTION" + string;
            columnMetadata.setLabel(string);
            columnMetadata.setName(string);
        }
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createShortMetaDataColumn("COLUMN_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("TYPE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("COLUMN_SIZE", Nullable.NULLABLE);
            columnMetadata.setName("PRECISION");
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("BUFFER_LENGTH", Nullable.NULLABLE);
            columnMetadata.setName("LENGTH");
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("DECIMAL_DIGITS", Nullable.NULLABLE);
            columnMetadata.setName("SCALE");
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("NUM_PREC_RADIX", Nullable.NULLABLE);
            columnMetadata.setName("RADIX");
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("NULLABLE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("CHAR_OCTET_LENGTH", Nullable.NULLABLE);
            columnMetadata.setName("CHAR_OCTET_LENGTH");
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("ORDINAL_POSITION", Nullable.NO_NULLS);
            columnMetadata.setName("ORDINAL_POSITION");
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("IS_NULLABLE", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("SPECIFIC_NAME", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createIndexInfoMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(13);
        MetaDataFactory.addCommonMetaData(arrayList);
        arrayList.remove(NUM_COMMON_TABLE_COLUMNS);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createBooleanMetaDataColumn("NON_UNIQUE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("INDEX_QUALIFIER", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("INDEX_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("ORDINAL_POSITION", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("COLUMN_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("ASC_OR_DESC", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("CARDINALITY", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("PAGES", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("FILTER_CONDITION", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createPrimaryKeysMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(6);
        MetaDataFactory.addCommonMetaData(arrayList);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createShortMetaDataColumn("KEY_SEQ", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("PK_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createProcedureColumnsMetaData(JDBCVersion jDBCVersion) {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(13);
        MetaDataFactory.addCommonMetaData(arrayList);
        for (int i = 0; i < NUM_COMMON_TABLE_COLUMNS; ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)arrayList.get(i);
            String string = columnMetadata.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            string = "PROCEDURE" + string;
            columnMetadata.setLabel(string);
            columnMetadata.setName(string);
        }
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createShortMetaDataColumn("COLUMN_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("TYPE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("COLUMN_SIZE", Nullable.NULLABLE);
            columnMetadata.setName("PRECISION");
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("BUFFER_LENGTH", Nullable.NULLABLE);
            columnMetadata.setName("LENGTH");
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("DECIMAL_DIGITS", Nullable.NULLABLE);
            columnMetadata.setName("SCALE");
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("NUM_PREC_RADIX", Nullable.NULLABLE);
            columnMetadata.setName("RADIX");
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("NULLABLE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("COLUMN_DEF", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATA_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATETIME_SUB", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("CHAR_OCTET_LENGTH", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("ORDINAL_POSITION", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("IS_NULLABLE", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("SPECIFIC_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createProceduresMetaData(JDBCVersion jDBCVersion) {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(8);
        MetaDataFactory.addCommonMetaData(arrayList);
        arrayList.remove(NUM_COMMON_TABLE_COLUMNS);
        for (int i = 0; i < NUM_COMMON_TABLE_COLUMNS; ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)arrayList.get(i);
            String string = columnMetadata.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            string = "PROCEDURE" + string;
            columnMetadata.setLabel(string);
            columnMetadata.setName(string);
        }
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("NUM_INPUT_PARAMS", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("NUM_OUTPUT_PARAMS", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("NUM_RESULT_SETS", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("PROCEDURE_TYPE", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("SPECIFIC_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createPseudoColumnsMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(13);
        MetaDataFactory.addCommonMetaData(arrayList);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("COLUMN_SIZE", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("DECIMAL_DIGITS", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("NUM_PREC_RADIX", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("COLUMN_USAGE", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("CHAR_OCTET_LENGTH", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("IS_NULLABLE", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createSchemasOnlyMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(2);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createStringMetaDataColumn("TABLE_SCHEM", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("TABLE_CATALOG", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createSpecialColumnsMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(8);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createShortMetaDataColumn("SCOPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("COLUMN_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("TYPE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("COLUMN_SIZE", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("BUFFER_LENGTH", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("DECIMAL_DIGITS", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("PSEUDO_COLUMN", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createSuperTablesMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(4);
        MetaDataFactory.addCommonMetaData(arrayList);
        arrayList.remove(3);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createStringMetaDataColumn("SUPERTABLE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createSuperTypesMetaData() {
        String string;
        ColumnMetadata columnMetadata;
        int n;
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(6);
        MetaDataFactory.addCommonMetaData(arrayList);
        arrayList.remove(NUM_COMMON_TABLE_COLUMNS);
        for (n = 0; n < NUM_COMMON_TABLE_COLUMNS; ++n) {
            columnMetadata = (ColumnMetadata)arrayList.get(n);
            string = columnMetadata.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            string = "TYPE" + string;
            columnMetadata.setLabel(string);
            columnMetadata.setName(string);
        }
        MetaDataFactory.addCommonMetaData(arrayList);
        arrayList.remove(6);
        for (n = NUM_COMMON_TABLE_COLUMNS; n < 2 * NUM_COMMON_TABLE_COLUMNS; ++n) {
            columnMetadata = (ColumnMetadata)arrayList.get(n);
            string = columnMetadata.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            string = "SUPERTYPE" + string;
            columnMetadata.setLabel(string);
            columnMetadata.setName(string);
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createTablePrivilegesMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(7);
        MetaDataFactory.addCommonMetaData(arrayList);
        arrayList.remove(3);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createStringMetaDataColumn("GRANTOR", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("GRANTEE", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("PRIVILEGE", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("IS_GRANTABLE", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createTablesMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(10);
        MetaDataFactory.addCommonMetaData(arrayList);
        arrayList.remove(3);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createStringMetaDataColumn("TABLE_TYPE", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("TYPE_CAT", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("TYPE_SCHEM", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("TYPE_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("SELF_REFERENCING_COL_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("REF_GENERATION", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createTableTypesMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(1);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createStringMetaDataColumn("TABLE_TYPE", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createTypeInfoMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(18);
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createStringMetaDataColumn("TYPE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("PRECISION", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("LITERAL_PREFIX", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("LITERAL_SUFFIX", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("CREATE_PARAMS", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("NULLABLE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createBooleanMetaDataColumn("CASE_SENSITIVE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("SEARCHABLE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createBooleanMetaDataColumn("UNSIGNED_ATTRIBUTE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createBooleanMetaDataColumn("FIXED_PREC_SCALE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createBooleanMetaDataColumn("AUTO_INCREMENT", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("LOCAL_TYPE_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("MINIMUM_SCALE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("MAXIMUM_SCALE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATA_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATETIME_SUB", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("NUM_PREC_RADIX", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<ColumnMetadata> createUDTMetaData() {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(7);
        MetaDataFactory.addCommonMetaData(arrayList);
        arrayList.remove(NUM_COMMON_TABLE_COLUMNS);
        for (int i = 0; i < NUM_COMMON_TABLE_COLUMNS; ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)arrayList.get(i);
            String string = columnMetadata.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            string = "TYPE" + string;
            columnMetadata.setLabel(string);
            columnMetadata.setName(string);
        }
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createStringMetaDataColumn("CLASS_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            arrayList.add(columnMetadata);
            columnMetadata = MetaDataFactory.createShortMetaDataColumn("BASE_TYPE", Nullable.NULLABLE);
            arrayList.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return arrayList;
    }

    private static void addCommonMetaData(List<ColumnMetadata> list) {
        try {
            ColumnMetadata columnMetadata = MetaDataFactory.createStringMetaDataColumn("TABLE_CAT", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            list.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("TABLE_SCHEM", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            list.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("TABLE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            list.add(columnMetadata);
            columnMetadata = MetaDataFactory.createStringMetaDataColumn("COLUMN_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            list.add(columnMetadata);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
    }

    private static ColumnMetadata createBooleanMetaDataColumn(String string, Nullable nullable) throws NumericOverflowException {
        TypeMetadata typeMetadata;
        try {
            typeMetadata = TypeMetadata.createTypeMetadata(-7);
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
        typeMetadata.setTypeName("BIT");
        typeMetadata.setLocalTypeName("BIT");
        ColumnMetadata columnMetadata = new ColumnMetadata(typeMetadata);
        columnMetadata.setLabel(string);
        columnMetadata.setName(string);
        columnMetadata.setNullable(nullable);
        columnMetadata.setSearchable(Searchable.PREDICATE_NONE);
        columnMetadata.setUpdatable(Updatable.READ_ONLY);
        columnMetadata.setColumnLength(COLUMN_SMALLINT_LENGTH);
        return columnMetadata;
    }

    private static ColumnMetadata createIntegerMetaDataColumn(String string, Nullable nullable) throws NumericOverflowException {
        TypeMetadata typeMetadata;
        try {
            typeMetadata = TypeMetadata.createTypeMetadata(4);
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
        typeMetadata.setTypeName("INTEGER");
        typeMetadata.setLocalTypeName("INTEGER");
        ColumnMetadata columnMetadata = new ColumnMetadata(typeMetadata);
        columnMetadata.setLabel(string);
        columnMetadata.setName(string);
        columnMetadata.setNullable(nullable);
        columnMetadata.setSearchable(Searchable.PREDICATE_NONE);
        columnMetadata.setUpdatable(Updatable.READ_ONLY);
        columnMetadata.setColumnLength(COLUMN_INTEGER_LENGTH);
        return columnMetadata;
    }

    private static ColumnMetadata createShortMetaDataColumn(String string, Nullable nullable) throws NumericOverflowException {
        TypeMetadata typeMetadata;
        try {
            typeMetadata = TypeMetadata.createTypeMetadata(5);
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
        typeMetadata.setTypeName("SMALLINT");
        typeMetadata.setLocalTypeName("SMALLINT");
        ColumnMetadata columnMetadata = new ColumnMetadata(typeMetadata);
        columnMetadata.setLabel(string);
        columnMetadata.setName(string);
        columnMetadata.setNullable(nullable);
        columnMetadata.setSearchable(Searchable.PREDICATE_NONE);
        columnMetadata.setUpdatable(Updatable.READ_ONLY);
        columnMetadata.setColumnLength(COLUMN_SMALLINT_LENGTH);
        return columnMetadata;
    }

    private static ColumnMetadata createStringMetaDataColumn(String string, Nullable nullable, int n) throws NumericOverflowException {
        TypeMetadata typeMetadata;
        try {
            typeMetadata = TypeMetadata.createTypeMetadata(12);
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
        typeMetadata.setTypeName("VARCHAR");
        typeMetadata.setLocalTypeName("VARCHAR");
        ColumnMetadata columnMetadata = new ColumnMetadata(typeMetadata);
        columnMetadata.setLabel(string);
        columnMetadata.setName(string);
        columnMetadata.setNullable(nullable);
        columnMetadata.setSearchable(Searchable.PREDICATE_NONE);
        columnMetadata.setUpdatable(Updatable.READ_ONLY);
        columnMetadata.setColumnLength(n);
        return columnMetadata;
    }
}

