/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine.metadata;

import com.simba.athena.amazonaws.services.athena.model.DataCatalogSummary;
import com.simba.athena.athena.AJMetadataRetrievalMethod;
import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.dataengine.metadata.AJSchemaMetadata;
import com.simba.athena.athena.dataengine.metadata.AJTableMetadata;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.athena.utilities.AJMetadataHelperUtilities;
import com.simba.athena.dsi.dataengine.filters.IFilter;
import com.simba.athena.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.athena.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.athena.jdbc.utils.StringWrapperFilter;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class AJTablesMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private AJClient m_client;
    private List<AJTableMetadata> m_tableMetadataList = new ArrayList<AJTableMetadata>();
    private ListIterator<AJTableMetadata> m_tableMetadataIterator;
    private AJTableMetadata m_currentTableMetadata;

    public AJTablesMetadataSource(ILogger iLogger, AJClient aJClient, ArrayList<IFilter> arrayList, String string, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, aJClient);
        this.m_client = aJClient;
        this.m_logger = iLogger;
        StringWrapperFilter stringWrapperFilter = null;
        StringWrapperFilter stringWrapperFilter2 = null;
        for (IFilter iFilter : arrayList) {
            switch (iFilter.getColumnTag()) {
                case SCHEMA_NAME: {
                    stringWrapperFilter = new StringWrapperFilter(iFilter);
                    break;
                }
                case TABLE_NAME: {
                    stringWrapperFilter2 = new StringWrapperFilter(iFilter);
                    break;
                }
            }
        }
        this.initMetadata(string, stringWrapperFilter, stringWrapperFilter2, map);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_catalogName, dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_schemaName, dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_tableName, dataWrapper, l, l2);
            }
            case TABLE_TYPE: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_tableType, dataWrapper, l, l2);
            }
            case REMARKS: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_remarks, dataWrapper, l, l2);
            }
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_tableMetadataIterator.hasNext();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.hasMoreRows()) {
            this.m_currentTableMetadata = this.m_tableMetadataIterator.next();
            return true;
        }
        return false;
    }

    private void initMetadata(String string, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        ArrayList<AJTableMetadata> arrayList;
        Iterator iterator;
        String string2;
        LogUtilities.logFunctionEntrance(this.m_logger, string, stringWrapperFilter, stringWrapperFilter2);
        String string3 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        if (null != string3 && string3.contains("\\") && !stringWrapperFilter.filter(string3)) {
            string3 = string3.replace("\\", "");
        }
        if (null != (string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME)) && string2.contains("\\") && !stringWrapperFilter2.filter(string2)) {
            string2 = string2.replace("\\", "");
        }
        ArrayList<AJSchemaMetadata> arrayList2 = new ArrayList<AJSchemaMetadata>();
        List<Object> list = new ArrayList();
        ArrayList<AJSchemaMetadata> arrayList3 = new ArrayList<AJSchemaMetadata>();
        if (null == string || string.isEmpty()) {
            if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_client.getMetadataRetrievalMethod()) {
                list = this.m_client.getCatalogsWtihProxyApi();
            } else {
                iterator = new DataCatalogSummary();
                ((DataCatalogSummary)((Object)iterator)).setCatalogName("AwsDataCatalog");
                list.add(iterator);
            }
        } else {
            iterator = new DataCatalogSummary();
            ((DataCatalogSummary)((Object)iterator)).setCatalogName(string);
            list.add(iterator);
        }
        for (DataCatalogSummary object : list) {
            if (null == string3 || string3.isEmpty()) {
                AJMetadataHelperUtilities.getSchemasWithCatalogCheck(object.getCatalogName(), string, this.m_client, arrayList3);
                continue;
            }
            arrayList = new AJSchemaMetadata(object.getCatalogName(), string3);
            arrayList3.add((AJSchemaMetadata)((Object)arrayList));
        }
        for (AJSchemaMetadata aJSchemaMetadata : arrayList3) {
            if (!stringWrapperFilter.filter(aJSchemaMetadata.m_schemaName)) continue;
            arrayList2.add(aJSchemaMetadata);
        }
        for (AJSchemaMetadata aJSchemaMetadata : arrayList2) {
            if (null == string2 || string2.isEmpty()) {
                arrayList = new ArrayList();
                this.m_client.getTablesMetadata(aJSchemaMetadata.m_catalogName, aJSchemaMetadata.m_schemaName, arrayList);
                for (AJTableMetadata aJTableMetadata : arrayList) {
                    if (!stringWrapperFilter2.filter(aJTableMetadata.m_tableName)) continue;
                    this.m_tableMetadataList.add(aJTableMetadata);
                }
                continue;
            }
            arrayList = new ArrayList<AJTableMetadata>();
            this.m_client.getTableMetadata(aJSchemaMetadata.m_catalogName, aJSchemaMetadata.m_schemaName, string2, arrayList);
            if (arrayList.isEmpty()) continue;
            this.m_tableMetadataList.add((AJTableMetadata)arrayList.get(0));
        }
        this.m_tableMetadataIterator = this.m_tableMetadataList.listIterator(0);
    }
}

