/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.transform;

import com.simba.athena.amazonaws.AmazonServiceException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.annotation.ThreadSafe;
import com.simba.athena.amazonaws.transform.AbstractErrorUnmarshaller;
import com.simba.athena.shaded.fasterxml.jackson.databind.DeserializationFeature;
import com.simba.athena.shaded.fasterxml.jackson.databind.JsonNode;
import com.simba.athena.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.simba.athena.shaded.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.simba.athena.shaded.fasterxml.jackson.databind.node.NullNode;

@SdkInternalApi
@ThreadSafe
public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JsonNode> {
    public static final JsonErrorUnmarshaller DEFAULT_UNMARSHALLER = new JsonErrorUnmarshaller(AmazonServiceException.class, null);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setPropertyNamingStrategy(new PropertyNamingStrategy.PascalCaseStrategy());
    private final String handledErrorCode;

    public JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass, String handledErrorCode) {
        super(exceptionClass);
        this.handledErrorCode = handledErrorCode;
    }

    @Override
    public AmazonServiceException unmarshall(JsonNode jsonContent) throws Exception {
        if (jsonContent == null || NullNode.instance.equals(jsonContent)) {
            return null;
        }
        return (AmazonServiceException)MAPPER.treeToValue(jsonContent, this.exceptionClass);
    }

    public boolean matchErrorCode(String actualErrorCode) {
        if (this.handledErrorCode == null) {
            return true;
        }
        return this.handledErrorCode.equals(actualErrorCode);
    }
}

