/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.BackfillError;
import com.simba.athena.amazonaws.services.glue.model.KeySchemaElement;
import com.simba.athena.amazonaws.services.glue.model.PartitionIndexStatus;
import com.simba.athena.amazonaws.services.glue.model.transform.PartitionIndexDescriptorMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PartitionIndexDescriptor
implements Serializable,
Cloneable,
StructuredPojo {
    private String indexName;
    private List<KeySchemaElement> keys;
    private String indexStatus;
    private List<BackfillError> backfillErrors;

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public PartitionIndexDescriptor withIndexName(String indexName) {
        this.setIndexName(indexName);
        return this;
    }

    public List<KeySchemaElement> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<KeySchemaElement> keys) {
        if (keys == null) {
            this.keys = null;
            return;
        }
        this.keys = new ArrayList<KeySchemaElement>(keys);
    }

    public PartitionIndexDescriptor withKeys(KeySchemaElement ... keys) {
        if (this.keys == null) {
            this.setKeys(new ArrayList<KeySchemaElement>(keys.length));
        }
        for (KeySchemaElement ele : keys) {
            this.keys.add(ele);
        }
        return this;
    }

    public PartitionIndexDescriptor withKeys(Collection<KeySchemaElement> keys) {
        this.setKeys(keys);
        return this;
    }

    public void setIndexStatus(String indexStatus) {
        this.indexStatus = indexStatus;
    }

    public String getIndexStatus() {
        return this.indexStatus;
    }

    public PartitionIndexDescriptor withIndexStatus(String indexStatus) {
        this.setIndexStatus(indexStatus);
        return this;
    }

    public PartitionIndexDescriptor withIndexStatus(PartitionIndexStatus indexStatus) {
        this.indexStatus = indexStatus.toString();
        return this;
    }

    public List<BackfillError> getBackfillErrors() {
        return this.backfillErrors;
    }

    public void setBackfillErrors(Collection<BackfillError> backfillErrors) {
        if (backfillErrors == null) {
            this.backfillErrors = null;
            return;
        }
        this.backfillErrors = new ArrayList<BackfillError>(backfillErrors);
    }

    public PartitionIndexDescriptor withBackfillErrors(BackfillError ... backfillErrors) {
        if (this.backfillErrors == null) {
            this.setBackfillErrors(new ArrayList<BackfillError>(backfillErrors.length));
        }
        for (BackfillError ele : backfillErrors) {
            this.backfillErrors.add(ele);
        }
        return this;
    }

    public PartitionIndexDescriptor withBackfillErrors(Collection<BackfillError> backfillErrors) {
        this.setBackfillErrors(backfillErrors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndexName() != null) {
            sb.append("IndexName: ").append(this.getIndexName()).append(",");
        }
        if (this.getKeys() != null) {
            sb.append("Keys: ").append(this.getKeys()).append(",");
        }
        if (this.getIndexStatus() != null) {
            sb.append("IndexStatus: ").append(this.getIndexStatus()).append(",");
        }
        if (this.getBackfillErrors() != null) {
            sb.append("BackfillErrors: ").append(this.getBackfillErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionIndexDescriptor)) {
            return false;
        }
        PartitionIndexDescriptor other = (PartitionIndexDescriptor)obj;
        if (other.getIndexName() == null ^ this.getIndexName() == null) {
            return false;
        }
        if (other.getIndexName() != null && !other.getIndexName().equals(this.getIndexName())) {
            return false;
        }
        if (other.getKeys() == null ^ this.getKeys() == null) {
            return false;
        }
        if (other.getKeys() != null && !other.getKeys().equals(this.getKeys())) {
            return false;
        }
        if (other.getIndexStatus() == null ^ this.getIndexStatus() == null) {
            return false;
        }
        if (other.getIndexStatus() != null && !other.getIndexStatus().equals(this.getIndexStatus())) {
            return false;
        }
        if (other.getBackfillErrors() == null ^ this.getBackfillErrors() == null) {
            return false;
        }
        return other.getBackfillErrors() == null || other.getBackfillErrors().equals(this.getBackfillErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexName() == null ? 0 : this.getIndexName().hashCode());
        hashCode = 31 * hashCode + (this.getKeys() == null ? 0 : this.getKeys().hashCode());
        hashCode = 31 * hashCode + (this.getIndexStatus() == null ? 0 : this.getIndexStatus().hashCode());
        hashCode = 31 * hashCode + (this.getBackfillErrors() == null ? 0 : this.getBackfillErrors().hashCode());
        return hashCode;
    }

    public PartitionIndexDescriptor clone() {
        try {
            return (PartitionIndexDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PartitionIndexDescriptorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

