/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.athena.model;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.athena.model.DataCatalogType;
import com.simba.athena.amazonaws.services.athena.model.transform.DataCatalogMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DataCatalog
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private String type;
    private Map<String, String> parameters;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DataCatalog withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public DataCatalog withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public DataCatalog withType(String type) {
        this.setType(type);
        return this;
    }

    public DataCatalog withType(DataCatalogType type) {
        this.type = type.toString();
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public DataCatalog withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public DataCatalog addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public DataCatalog clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCatalog)) {
            return false;
        }
        DataCatalog other = (DataCatalog)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public DataCatalog clone() {
        try {
            return (DataCatalog)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataCatalogMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

