/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvConst;
import com.ingres.gcf.jdbc.DrvRsrc;
import com.ingres.gcf.jdbc.JdbcConn;
import com.ingres.gcf.jdbc.TraceDM;
import com.ingres.gcf.util.Config;
import com.ingres.gcf.util.ConfigKey;
import com.ingres.gcf.util.ConfigProp;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.TraceLog;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.ResourceBundle;

public abstract class JdbcDrv
implements Driver,
DrvConst,
GcfErr {
    public static final String driverVendor = "Ingres Corporation";
    public static final String driverJdbcVersion = "JDBC 4.0";
    public static final int driverMajorVersion = 4;
    public static final int driverMinorVersion = 0;
    public static final int driverPatchVersion = 7;
    private String full_protocol_id = "jdbc:" + this.loadProtocolID() + ":";
    private TraceDM trace = new TraceDM(this.loadTraceLog(), this.loadTraceName(), "drv");
    private String title = this.loadTraceName() + "-Driver";
    private static final String tr_id = "Drv";

    protected abstract Config loadConfig();

    protected abstract String loadDriverName();

    protected abstract String loadProtocolID();

    protected abstract String loadTraceName();

    protected abstract TraceLog loadTraceLog();

    protected JdbcDrv() {
    }

    public String toString() {
        return this.loadDriverName();
    }

    @Override
    public boolean jdbcCompliant() {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".jdbcCompliant(): " + true);
        }
        return true;
    }

    @Override
    public int getMajorVersion() {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMajorVersion(): " + 4);
        }
        return 4;
    }

    @Override
    public int getMinorVersion() {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMinorVersion(): " + 0);
        }
        return 0;
    }

    public int getPatchVersion() {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPatchVersion(): " + 7);
        }
        return 7;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        boolean bl = this.accept(string);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".acceptsURL(): " + bl);
        }
        return bl;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPropertyInfo()");
        }
        if (!this.accept(string)) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getPropertyInfo(): URL not accepted!");
            }
            throw SqlExFactory.get(ERR_GC4000_BAD_URL);
        }
        Config config = this.getProperties(string, properties);
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[propInfo.length];
        for (int i = 0; i < propInfo.length; ++i) {
            String string2 = config.get(JdbcDrv.propInfo[i].name);
            if (string2 == null) {
                string2 = JdbcDrv.propInfo[i].dflt;
            }
            driverPropertyInfoArray[i] = new DriverPropertyInfo(JdbcDrv.propInfo[i].name, string2);
            driverPropertyInfoArray[i].description = JdbcDrv.propInfo[i].desc;
            driverPropertyInfoArray[i].required = JdbcDrv.propInfo[i].req;
            driverPropertyInfoArray[i].choices = JdbcDrv.propInfo[i].valid;
        }
        return driverPropertyInfoArray;
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        JdbcConn jdbcConn;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".connect()");
        }
        if (!this.accept(string)) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".connect(): URL not accepted!");
            }
            return null;
        }
        try {
            Config config = this.getProperties(string, properties);
            DrvConn drvConn = new DrvConn(this.getHost(string), this.loadConfig(), this.trace, false);
            drvConn.driverName = this.loadDriverName();
            drvConn.protocol = this.loadProtocolID();
            jdbcConn = new JdbcConn(drvConn, config, DriverManager.getLoginTimeout());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".connect(): error establishing connection");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".connect(): " + jdbcConn);
        }
        return jdbcConn;
    }

    public void setTraceLog(String string) {
        this.trace.getTraceLog().setTraceLog(string);
    }

    public void setTraceLevel(String string, int n) {
        this.trace.getTraceLog().getTraceLevel(string).set(n);
    }

    public void setTraceLevel(int n) {
        this.trace.setTraceLevel(n);
    }

    private boolean accept(String string) {
        return string.regionMatches(true, 0, this.full_protocol_id, 0, this.full_protocol_id.length());
    }

    private Config getProperties(String string, Properties properties) throws SQLException {
        String string2;
        Properties properties2 = new Properties();
        Config config = new ConfigKey("property", this.loadConfig());
        if (properties != null) {
            config = new ConfigProp(properties, config);
        }
        config = new ConfigProp(properties2, config);
        String string3 = this.getDatabase(string);
        if (string3 != null) {
            properties2.put("database", string3);
        }
        if ((string2 = this.getAttributes(string)) == null) {
            return config;
        }
        int n = 0;
        while (n < string2.length()) {
            int n2;
            block11: {
                block13: {
                    block12: {
                        n2 = string2.indexOf(59, n);
                        if (n2 >= n) break block12;
                        n2 = string2.length();
                        break block13;
                    }
                    if (n2 == n) break block11;
                }
                int n3 = string2.indexOf(61, n);
                if (n3 <= n || n3 >= n2 - 1) {
                    if (this.trace.enabled(1)) {
                        this.trace.write("Drv: Invalid URL - bad attribute syntax '" + string2.substring(n, n2));
                    }
                    throw SqlExFactory.get(ERR_GC4000_BAD_URL);
                }
                String string4 = string2.substring(n, n3);
                string3 = string2.substring(n3 + 1, n2);
                for (int i = 0; i < attrInfo.length; ++i) {
                    if (!string4.equalsIgnoreCase(JdbcDrv.attrInfo[i].attrName) && !string4.equalsIgnoreCase(JdbcDrv.attrInfo[i].propName)) continue;
                    properties2.put(JdbcDrv.attrInfo[i].propName, string3);
                    break block11;
                }
                if (this.trace.enabled(1)) {
                    this.trace.write("Drv: Invalid URL - unrecognized attribute '" + string4 + "'");
                }
                throw SqlExFactory.get(ERR_GC4000_BAD_URL);
            }
            n = n2 + 1;
        }
        return config;
    }

    private String getHost(String string) {
        int n = this.findHost(string);
        int n2 = this.findDb(string, n);
        return n < string.length() ? string.substring(n + 2, n2) : null;
    }

    private String getDatabase(String string) {
        int n = this.findDb(string, this.findHost(string));
        int n2 = this.findAttr(string, n);
        return n < string.length() ? string.substring(n + 1, n2) : null;
    }

    private String getAttributes(String string) {
        int n = this.findAttr(string, this.findDb(string, this.findHost(string)));
        return n < string.length() ? string.substring(n + 1) : null;
    }

    private int findHost(String string) {
        int n = this.full_protocol_id.length();
        if (string.length() <= n + 1 || string.charAt(n) != '/' || string.charAt(n + 1) != '/') {
            n = string.length();
        }
        return n;
    }

    private int findDb(String string, int n) {
        int n2 = string.indexOf(47, n + 2);
        return n2 < 0 ? string.length() : n2;
    }

    private int findAttr(String string, int n) {
        int n2 = string.indexOf(59, n + 1);
        return n2 < 0 ? string.length() : n2;
    }

    static {
        ResourceBundle resourceBundle = DrvRsrc.getResource();
        for (int i = 0; i < propInfo.length; ++i) {
            try {
                JdbcDrv.propInfo[i].desc = resourceBundle.getString(JdbcDrv.propInfo[i].rsrcID);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

