/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryExecutionContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryExecutionContext> {
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(QueryExecutionContext.getter(QueryExecutionContext::database)).setter(QueryExecutionContext.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(QueryExecutionContext.getter(QueryExecutionContext::catalog)).setter(QueryExecutionContext.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_FIELD, CATALOG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String database;
    private final String catalog;

    private QueryExecutionContext(BuilderImpl builder) {
        this.database = builder.database;
        this.catalog = builder.catalog;
    }

    public final String database() {
        return this.database;
    }

    public final String catalog() {
        return this.catalog;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionContext)) {
            return false;
        }
        QueryExecutionContext other = (QueryExecutionContext)obj;
        return Objects.equals(this.database(), other.database()) && Objects.equals(this.catalog(), other.catalog());
    }

    public final String toString() {
        return ToString.builder((String)"QueryExecutionContext").add("Database", (Object)this.database()).add("Catalog", (Object)this.catalog()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryExecutionContext, T> g) {
        return obj -> g.apply((QueryExecutionContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String database;
        private String catalog;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionContext model) {
            this.database(model.database);
            this.catalog(model.catalog);
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        @Transient
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        @Transient
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public QueryExecutionContext build() {
            return new QueryExecutionContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryExecutionContext> {
        public Builder database(String var1);

        public Builder catalog(String var1);
    }
}

