/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.core.breakpoints;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.jkiss.dbeaver.debug.DBGBreakpointDescriptor;
import org.jkiss.dbeaver.debug.core.breakpoints.IDatabaseBreakpoint;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DatabaseBreakpoint
extends Breakpoint
implements IDatabaseBreakpoint {
    public String getModelIdentifier() {
        return "org.jkiss.dbeaver.debug.core.database";
    }

    @Override
    public String getDatasourceId() throws CoreException {
        return this.ensureMarker().getAttribute("org.jkiss.dbeaver.runtime.marker.datasourceId", null);
    }

    @Override
    public String getNodePath() throws CoreException {
        return this.ensureMarker().getAttribute("org.jkiss.dbeaver.runtime.marker.nodePath", null);
    }

    @Override
    public String getObjectName() throws CoreException {
        return this.ensureMarker().getAttribute("org.jkiss.dbeaver.debug.core.objectName", null);
    }

    protected void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin plugin = DebugPlugin.getDefault();
            if (plugin != null) {
                plugin.getBreakpointManager().addBreakpoint((IBreakpoint)this);
            }
        } else {
            this.setRegistered(false);
        }
    }

    protected void addDatabaseBreakpointAttributes(Map<String, Object> attributes, DBSObject databaseObject, DBNNode node, DBGBreakpointDescriptor breakpointDescriptor) {
        attributes.put("org.jkiss.dbeaver.runtime.marker.datasourceId", databaseObject.getDataSource().getContainer().getId());
        attributes.put("org.jkiss.dbeaver.runtime.marker.nodePath", node.getNodeItemPath());
        attributes.put("org.jkiss.dbeaver.debug.core.objectName", DBUtils.getObjectFullName((DBPNamedObject)databaseObject, (DBPEvaluationContext)DBPEvaluationContext.UI));
        attributes.putAll(breakpointDescriptor.toMap());
    }
}

