/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.ui;

import com.dbeaver.db.netezza.ui.NetezzaMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ext.generic.views.GenericConnectionPage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class NetezzaConnectionPage
extends GenericConnectionPage {
    private Button showAllDatabases;
    private Button schemaOffMode;

    public void createAdvancedSettingsGroup(Composite composite) {
        Group advancedSettings = new Group(composite, 0);
        advancedSettings.setText(NetezzaMessages.connection_page_group_advanced_settings);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        advancedSettings.setLayoutData((Object)gridData);
        advancedSettings.setLayout((Layout)new GridLayout(1, false));
        this.showAllDatabases = UIUtils.createCheckbox((Composite)advancedSettings, (String)NetezzaMessages.connection_page_checkbox_show_all_databases_label, (String)NetezzaMessages.connection_page_checkbox_show_all_databases_tip, (boolean)false, (int)1);
        this.schemaOffMode = UIUtils.createCheckbox((Composite)advancedSettings, (String)NetezzaMessages.connection_page_checkbox_owners_instead_schemas_label, (String)NetezzaMessages.connection_page_checkbox_owners_instead_schemas_tip, (boolean)false, (int)1);
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        this.showAllDatabases.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("show-all-databases@")));
        this.schemaOffMode.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("switch-owner-name@")));
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.showAllDatabases != null) {
            connectionInfo.setProviderProperty("show-all-databases@", String.valueOf(this.showAllDatabases.getSelection()));
        }
        if (this.schemaOffMode != null) {
            connectionInfo.setProviderProperty("switch-owner-name@", String.valueOf(this.schemaOffMode.getSelection()));
        }
        super.saveSettings(dataSource);
    }
}

