/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.SybConnectionPoolDataSource;
import com.sybase.jdbc4.jdbc.SybDataSource;
import com.sybase.jdbc4.jdbc.SybJndiProvider;
import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.jdbc.SybXADataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.DirContext;
import javax.naming.spi.ObjectFactory;

public class SybObjectFactory
implements ObjectFactory {
    static final String SYB_DATA_SOURCE_CLASSNAME = SybDataSource.class.getName();
    static final String SYB_POOLED_DATA_SOURCE_CLASSNAME = SybConnectionPoolDataSource.class.getName();
    static final String SYB_XA_DATA_SOURCE_CLASSNAME = SybXADataSource.class.getName();
    static final String DATASOURCE_NAME = "DataSource";
    static final String CONNECTIONPOOLDATASOURCE_NAME = "ConnectionPoolDataSource";
    static final String XADATASOURCE_NAME = "XADataSource";

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) {
        Object object2 = null;
        if (object != null) {
            if (object instanceof DirContext && context instanceof DirContext) {
                object2 = this.getObjectUsingDirContext(name, (DirContext)context);
            } else if (object instanceof Reference) {
                object2 = this.getObjectUsingReference((Reference)object, name, context, hashtable);
            }
        }
        return object2;
    }

    protected Object getObjectUsingReference(Reference reference, Name name, Context context, Hashtable hashtable) {
        SybDataSource sybDataSource = null;
        if (reference != null) {
            try {
                SybDataSource sybDataSource2 = null;
                if (reference.getClassName().equals(SYB_DATA_SOURCE_CLASSNAME)) {
                    sybDataSource2 = new SybDataSource();
                } else if (reference.getClassName().equals(SYB_POOLED_DATA_SOURCE_CLASSNAME)) {
                    sybDataSource2 = new SybConnectionPoolDataSource();
                } else if (reference.getClassName().equals(SYB_XA_DATA_SOURCE_CLASSNAME)) {
                    sybDataSource2 = new SybXADataSource();
                }
                if (sybDataSource2 != null) {
                    sybDataSource2.setDatabaseName((String)reference.get("databaseName").getContent());
                    sybDataSource2.setDataSourceName((String)reference.get("dataSourceName").getContent());
                    sybDataSource2.setDescription((String)reference.get("description").getContent());
                    sybDataSource2.setNetworkProtocol((String)reference.get("networkProtocol").getContent());
                    sybDataSource2.setPortNumber((String)reference.get("portNumber").getContent());
                    sybDataSource2.setServerName((String)reference.get("serverName").getContent());
                    sybDataSource2.setUser((String)reference.get("user").getContent());
                    sybDataSource2.setPassword((String)reference.get("password").getContent());
                    sybDataSource2.setResourceManagerName((String)reference.get("resourceManagerName").getContent());
                    sybDataSource2.setResourceManagerType(Integer.parseInt((String)reference.get("resourceManagerType").getContent()));
                    sybDataSource2.setAddressList((String)reference.get("addressList").getContent());
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])reference.get("sybProperty").getContent());
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    sybDataSource2.setSybProperty((SybProperty)objectInputStream.readObject());
                    sybDataSource = sybDataSource2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InvalidClassException invalidClassException) {
            }
            catch (StreamCorruptedException streamCorruptedException) {
            }
            catch (OptionalDataException optionalDataException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sybDataSource;
    }

    protected Object getObjectUsingDirContext(Name name, DirContext dirContext) {
        SybDataSource sybDataSource = null;
        try {
            SybProperty sybProperty = new SybDataSource().getSybProperty();
            SybJndiProvider sybJndiProvider = new SybJndiProvider(dirContext, name, sybProperty);
            SybDataSource sybDataSource2 = null;
            String string = sybJndiProvider.getDataSourceInterface();
            if (string.equals(DATASOURCE_NAME)) {
                sybDataSource2 = new SybDataSource();
            } else if (string.equalsIgnoreCase(CONNECTIONPOOLDATASOURCE_NAME)) {
                sybDataSource2 = new SybConnectionPoolDataSource();
            } else if (string.equalsIgnoreCase(XADATASOURCE_NAME)) {
                sybDataSource2 = new SybXADataSource();
            }
            if (sybDataSource2 != null) {
                sybDataSource2.setAddressList(sybJndiProvider.getHostPortList());
                sybDataSource2.setDatabaseName(sybJndiProvider.getDatabaseName());
                sybDataSource2.setSybProperty(sybJndiProvider.getSybProperty());
                sybDataSource2.setResourceManagerName(sybJndiProvider.getResourceManagerName());
                sybDataSource2.setResourceManagerType(sybJndiProvider.getResourceManagerType());
            }
            sybDataSource = sybDataSource2;
        }
        catch (SQLException sQLException) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return sybDataSource;
    }
}

