/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.ui.search;

import com.dbeaver.ee.qm.db.impl.QMDBModel;
import com.dbeaver.ee.qm.db.model.QMDBQueryFilter;
import com.dbeaver.ee.qmdb.ui.search.SearchQueriesParams;
import com.dbeaver.ee.qmdb.ui.search.SearchQueriesResults;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class SearchQueriesQuery
implements ISearchQuery {
    private static final Log log = Log.getLog(SearchQueriesQuery.class);
    private final SearchQueriesParams params;
    private SearchQueriesResults searchResult;

    private SearchQueriesQuery(SearchQueriesParams params) {
        this.params = params;
    }

    public String getLabel() {
        return this.params.getSearchString();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.searchResult = new SearchQueriesResults(this);
        }
        return this.searchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            DefaultProgressMonitor pm = new DefaultProgressMonitor(monitor);
            String searchString = this.params.getSearchString();
            monitor.beginTask("Search \"" + searchString + " is SQL history", 1);
            try {
                monitor.worked(1);
                QMDBQueryFilter filter = new QMDBQueryFilter();
                filter.setQueryText(searchString);
                filter.setRowOffset(0);
                filter.setMaxRows(1000);
                List records = QMDBModel.getInstance().searchQueryHistory((DBRProgressMonitor)pm, filter);
                this.searchResult.addObjects(records);
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return GeneralUtils.makeExceptionStatus((Throwable)e);
        }
    }

    public static SearchQueriesQuery createQuery(SearchQueriesParams params) throws DBException {
        return new SearchQueriesQuery(params);
    }

    private class SearchTableMonitor
    extends VoidProgressMonitor {
        private volatile boolean canceled;

        private SearchTableMonitor() {
        }

        public boolean isCanceled() {
            return this.canceled;
        }
    }
}

