/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.PSConfig;
import com.ibm.as400.access.PSController;
import com.ibm.as400.access.PSLoad;
import com.ibm.as400.access.PSLoadBalancer;
import com.ibm.as400.access.PSServerSocketContainer;
import com.ibm.as400.access.PSServerSocketContainerAdapter;
import com.ibm.as400.access.PxPeerConnection;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.StoppableThread;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Verbose;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class ProxyServer {
    private static final PrintStream errors_ = System.err;
    private PSConfig configuration_;
    private PSLoad load_ = new PSLoad();
    private PSLoadBalancer loadBalancer_ = new PSLoadBalancer(this.load_);
    private int port_ = 3470;
    private int securePort_ = 3471;
    private String keyringName_ = null;
    private String keyringPwd_ = null;
    private Vector threadGroup_ = null;

    public ProxyServer() {
        this.configuration_ = new PSConfig(this.load_, this.loadBalancer_);
    }

    public int getActiveConnections() {
        return this.load_.getActiveConnections();
    }

    public int getBalanceThreshold() {
        return this.load_.getBalanceThreshold();
    }

    public String getConfiguration() {
        return this.configuration_.getName();
    }

    public String getKeyring() {
        return this.keyringName_;
    }

    String getKeyringPassword() {
        return this.keyringPwd_;
    }

    public int getMaxConnections() {
        return this.load_.getMaxConnections();
    }

    public String[] getPeers() {
        return this.loadBalancer_.getPeers();
    }

    public int getPort() {
        return this.port_;
    }

    public int getSecurePort() {
        return this.securePort_;
    }

    public boolean isStarted() {
        return this.threadGroup_ != null;
    }

    public boolean isVerbose() {
        return Verbose.isVerbose();
    }

    public static void main(String[] stringArray) {
        ProxyServer proxyServer = new ProxyServer();
        if (proxyServer.parseArgs(stringArray)) {
            Verbose.forcePrintln(ResourceBundleLoader.getText("PROXY_SERVER_STARTED"));
            proxyServer.start();
        } else {
            PSConfig.usage(System.err);
        }
    }

    private boolean parseArgs(String[] stringArray) {
        String string;
        String string2;
        CommandLineArguments commandLineArguments = new CommandLineArguments(stringArray, PSConfig.expectedOptions_, PSConfig.shortcuts_);
        if (commandLineArguments.getOptionValue("-help") != null) {
            return false;
        }
        try {
            this.configuration_.apply(commandLineArguments);
        }
        catch (Exception exception) {
            errors_.println(exception.getMessage());
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Exception while parsing command line arguments", (Throwable)exception);
            }
            return false;
        }
        String string3 = commandLineArguments.getOptionValue("-port");
        if (string3 != null && string3.length() > 0) {
            this.setPort(Integer.parseInt(string3));
        }
        if ((string2 = commandLineArguments.getOptionValue("-securePort")) != null && string2.length() > 0) {
            this.setSecurePort(Integer.parseInt(string2));
        }
        String string4 = commandLineArguments.getOptionValue("-keyringName");
        String string5 = commandLineArguments.getOptionValue("-keyringPassword");
        try {
            Class.forName("com.ibm.sslight.SSLContext");
            if (string4 != null && string5 != null) {
                if (string4.length() > 0 && string5.length() > 0) {
                    this.setKeyringName(string4);
                    this.setKeyringPassword(string5);
                } else {
                    Verbose.forcePrintln("\n" + ResourceBundleLoader.getText("PROXY_SERVER_NO_KEYRING") + "\n");
                }
            } else {
                Verbose.forcePrintln("\n" + ResourceBundleLoader.getText("PROXY_SERVER_KEYRING_EXPLAIN") + "\n");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Enumeration enumeration = commandLineArguments.getExtraOptions();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement().toString();
            errors_.println(ResourceBundleLoader.getText("PROXY_OPTION_NOT_VALID", string));
        }
        string = commandLineArguments.getOptionValue("-");
        if (string != null && string.length() > 0) {
            errors_.println(ResourceBundleLoader.getText("PROXY_VALUE_NO_OPTION", string));
        }
        return true;
    }

    public void setBalanceThreshold(int n) {
        this.load_.setBalanceThreshold(n);
    }

    public void setConfiguration(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("configuration");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("configuration", 2);
        }
        this.configuration_.setName(string);
        this.configuration_.load();
    }

    public void setKeyringName(String string) {
        if (string == null) {
            throw new NullPointerException("keyringName");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("keyringName", 2);
        }
        this.keyringName_ = string;
    }

    public void setKeyringPassword(String string) {
        if (string == null) {
            throw new NullPointerException("keyringPassword");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("keyringPassword", 2);
        }
        this.keyringPwd_ = string;
    }

    public void setMaxConnections(int n) {
        this.load_.setMaxConnections(n);
    }

    public void setPeers(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("peers");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new NullPointerException("peers[" + i + "]");
            }
            if (stringArray[i].length() != 0) continue;
            throw new ExtendedIllegalArgumentException("peers[" + i + "]", 2);
        }
        this.loadBalancer_.setPeers(stringArray);
    }

    public void setPort(int n) {
        if (this.isStarted()) {
            throw new ExtendedIllegalStateException("port", 5);
        }
        if (n < 0 || n > 65535) {
            throw new ExtendedIllegalArgumentException("port", 4);
        }
        this.port_ = n;
    }

    public void setSecurePort(int n) {
        if (this.isStarted()) {
            throw new ExtendedIllegalStateException("port", 5);
        }
        if (n < 0 || n > 65535) {
            throw new ExtendedIllegalArgumentException("port", 4);
        }
        this.securePort_ = n;
    }

    public void setVerbose(boolean bl) {
        Verbose.setVerbose(bl);
    }

    public void start() {
        Class[] classArray;
        Object object;
        if (this.threadGroup_ != null) {
            throw new ExtendedIllegalStateException(7);
        }
        this.threadGroup_ = new Vector();
        try {
            object = new PSServerSocketContainer(this.port_);
            this.port_ = ((PSServerSocketContainerAdapter)object).getLocalPort();
            classArray = new PSController(this.threadGroup_, this, this.load_, this.loadBalancer_, this.configuration_, (PSServerSocketContainerAdapter)object);
            classArray.start();
            this.threadGroup_.addElement(classArray);
            Verbose.println(ResourceBundleLoader.getText("PROXY_SERVER_LISTENING", object, Integer.toString(this.port_)));
        }
        catch (BindException bindException) {
            Verbose.println(ResourceBundleLoader.getText("PROXY_ALREADY_LISTENING", Integer.toString(this.port_)));
            try {
                PxPeerConnection pxPeerConnection = new PxPeerConnection(InetAddress.getLocalHost().getHostName() + ":" + this.port_);
                pxPeerConnection.configure(this.configuration_);
                pxPeerConnection.close();
                return;
            }
            catch (UnknownHostException unknownHostException) {
                if (Trace.isTraceErrorOn()) {
                    Trace.log(2, "Peer host is unknown.", (Throwable)bindException);
                }
                errors_.println(bindException.getMessage());
            }
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Error opening server socket.", (Throwable)iOException);
            }
            errors_.println(iOException.getMessage());
        }
        try {
            Class.forName("com.ibm.sslight.SSLContext");
            if (this.keyringName_ != null && this.keyringPwd_ != null) {
                object = Class.forName("com.ibm.as400.access.PSSecureServerSocketContainer");
                classArray = new Class[]{Integer.TYPE, "".getClass(), "".getClass()};
                Constructor constructor = ((Class)object).getConstructor(classArray);
                Object[] objectArray = new Object[]{new Integer(this.securePort_), this.keyringName_, this.keyringPwd_};
                Object t = constructor.newInstance(objectArray);
                try {
                    classArray = new Class[]{};
                    Method method = ((Class)object).getMethod("getLocalPort", classArray);
                    objectArray = new Object[]{};
                    this.securePort_ = (Integer)method.invoke(t, objectArray);
                    PSController pSController = new PSController(this.threadGroup_, this, this.load_, this.loadBalancer_, this.configuration_, (PSServerSocketContainerAdapter)t);
                    pSController.start();
                    this.threadGroup_.addElement(pSController);
                    Verbose.println(ResourceBundleLoader.getText("PROXY_SERVER_LISTENING", t, Integer.toString(this.securePort_)));
                }
                catch (NullPointerException nullPointerException) {
                    Verbose.println(ResourceBundleLoader.getText("PROXY_SERVER_LISTENING", "Secure proxy server NOT", Integer.toString(this.securePort_)));
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (Trace.isTraceDiagnosticOn()) {
                Trace.log(1, "NoSuchMethodException using SSLight classes SSL support is not enabled.");
            }
            errors_.println(noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (Trace.isTraceDiagnosticOn()) {
                Trace.log(1, "InvocationTargetException using SSLight classes SSL support is not enabled.");
            }
            errors_.println(invocationTargetException.getMessage());
            classArray = invocationTargetException.getCause();
            if (classArray != null) {
                errors_.println(classArray.getMessage());
            }
        }
        catch (InstantiationException instantiationException) {
            if (Trace.isTraceDiagnosticOn()) {
                Trace.log(1, "InstantiationException using SSLight classes SSL support is not enabled.");
            }
            errors_.println(instantiationException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Trace.isTraceDiagnosticOn()) {
                Trace.log(1, "SSLight classes are not in the classpath, SSL support is not enabled.");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (Trace.isTraceDiagnosticOn()) {
                Trace.log(1, "IllegalArgumentException using SSLight classes SSL support is not enabled.");
            }
            errors_.println(illegalArgumentException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            if (Trace.isTraceDiagnosticOn()) {
                Trace.log(1, "IllegalAccessException using SSLight classes SSL support is not enabled.");
            }
            errors_.println(illegalAccessException.getMessage());
        }
    }

    public void stop() {
        if (this.threadGroup_ == null) {
            throw new ExtendedIllegalStateException(8);
        }
        this.load_.allConnectionsClosed();
        Enumeration enumeration = this.threadGroup_.elements();
        while (enumeration.hasMoreElements()) {
            ((StoppableThread)enumeration.nextElement()).stopSafely();
        }
        this.threadGroup_ = null;
    }

    static {
        SystemProperties.ignoreProperty("com.ibm.as400.access.AS400.proxyServer");
    }
}

