/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import org.netezza.Driver;
import org.netezza.error.NzFeatureNotSupportedException;
import org.netezza.error.NzMethodNotImplementedException;
import org.netezza.error.NzSQLException;
import org.netezza.internal.EscapeFunction;
import org.netezza.internal.NzFeature;
import org.netezza.internal.NzQuery;
import org.netezza.internal.ParseException;
import org.netezza.sql.NzConnection;
import org.netezza.sql.NzResultSet;

public class NzDatabaseMetadata
implements DatabaseMetaData {
    private static final String SQL_KEYWORDS = "ABORT,ACL,ADD,AGGREGATE,APPEND,ARCHIVE,ARCH_STORE,BACKWARD,BINARY,CHANGE,CLUSTER,COPY,DATABASE,DELIMITER,DELIMITERS,DO,EXTEND,EXPLAIN,FORWARD,HEAVY,INDEX,INHERITS,ISNULL,LIGHT,LISTEN,LOAD,MERGE,NOTHING,NOTIFY,NOTNULL,OIDS,PURGE,RENAME,REPLACE,RETRIEVE,RETURNS,RULE,RECIPE,SETOF,STDIN,STDOUT,STORE,VACUUM,VERBOSE,VERSION";
    private final NzConnection connection;
    private final MetaDataQuery metadataQuery;
    private static final String defaultCatalog = "current_catalog";
    private static final String defaultSchema = "current_schema";

    public NzDatabaseMetadata(NzConnection connection) {
        this.connection = connection;
        this.metadataQuery = new MetaDataQuery();
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new NzMethodNotImplementedException("NzDatabaseMetadata", "getAttributes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String method = "getBestRowIdentifier";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schema, table, scope, "" + nullable);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            boolean isCatalogCaseSensitive = this.isCaseSensitive(catalog);
            boolean isSchemaCaseSensitive = this.isCaseSensitive(schema);
            boolean isTableCaseSensitive = this.isCaseSensitive(table);
            boolean nullReplacesEmpty = false;
            this.metadataQuery.appendView(catalog, new String[]{"_V_JDBC_BESTROWIDENTIFIER1", "_V_JDBC_BESTROWIDENTIFIER2", "_V_JDBC_BESTROWIDENTIFIER3"});
            this.metadataQuery.append(" WHERE TRUE  AND SCOPE >= " + scope);
            if (isCatalogCaseSensitive) {
                catalog = catalog.substring(1, catalog.length() - 1);
            }
            if (isSchemaCaseSensitive) {
                schema = schema.substring(1, schema.length() - 1);
            }
            if (isTableCaseSensitive) {
                table = table.substring(1, table.length() - 1);
            }
            this.metadataQuery.appendCatalog("TABLE_CAT", catalog, isCatalogCaseSensitive);
            this.metadataQuery.appendSchema("TABLE_SCHEM", schema, isSchemaCaseSensitive);
            this.metadataQuery.append("TABLE_NAME", table, isTableCaseSensitive);
            this.metadataQuery.append(" ORDER BY  SCOPE ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCatalogs() throws SQLException {
        String method = "getCatalogs";
        this.connection.LOGGER.entry(this.getClass(), method);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            if (NzFeature.SCHEMA_WORKAROUND.isSet()) {
                this.metadataQuery.append("_V_JDBC_CATALOG3 ");
            } else if (NzFeature.CROSS_DATABASE.isSet()) {
                this.metadataQuery.append("_V_JDBC_CATALOG2 ");
            } else if (NzFeature.CATALOG_API.isSet()) {
                this.metadataQuery.append("_V_JDBC_CATALOG1 ");
            } else {
                NzCatalogCurruptException e = new NzCatalogCurruptException();
                this.connection.LOGGER.fatal(this.getClass(), method, e);
                throw e;
            }
            this.metadataQuery.append(" ORDER BY TABLE_CAT");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new NzMethodNotImplementedException("NzDatabaseMetaData", "getColumnPrivileges");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String method = "getColumns";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            boolean isCatalogCaseSensitive = this.isCaseSensitive(catalog);
            boolean isSchemaCaseSensitive = this.isCaseSensitive(schemaPattern);
            boolean isTableCaseSensitive = this.isCaseSensitive(tableNamePattern);
            boolean isColumnCaseSensitive = this.isCaseSensitive(columnNamePattern);
            boolean nullReplacsEmpty = false;
            this.metadataQuery.appendView(catalog, new String[]{"_V_JDBC_COLUMNS1", "_V_JDBC_COLUMNS2", "_V_JDBC_COLUMNS3"});
            this.metadataQuery.append(" WHERE TRUE ");
            if (isCatalogCaseSensitive) {
                catalog = catalog.substring(1, catalog.length() - 1);
            }
            if (isSchemaCaseSensitive) {
                schemaPattern = schemaPattern.substring(1, schemaPattern.length() - 1);
            }
            if (isTableCaseSensitive) {
                tableNamePattern = tableNamePattern.substring(1, tableNamePattern.length() - 1);
            }
            if (isColumnCaseSensitive) {
                columnNamePattern = columnNamePattern.substring(1, columnNamePattern.length() - 1);
            }
            this.metadataQuery.appendCatalog("TABLE_CAT", catalog, isCatalogCaseSensitive);
            this.metadataQuery.appendSchema("TABLE_SCHEM", schemaPattern, isSchemaCaseSensitive);
            this.metadataQuery.append("TABLE_NAME", tableNamePattern, isTableCaseSensitive);
            this.metadataQuery.append("COLUMN_NAME", columnNamePattern, isColumnCaseSensitive);
            this.metadataQuery.append(" ORDER BY  TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String method = "getCrossReference";
        this.connection.LOGGER.entry(this.getClass(), method, primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            boolean isPrimCatalogCaseSensitive = this.isCaseSensitive(primaryCatalog);
            boolean isPrimSchemaCaseSensitive = this.isCaseSensitive(primarySchema);
            boolean isPrimTableCaseSensitive = this.isCaseSensitive(primaryTable);
            boolean isForeignCatalogCaseSensitive = this.isCaseSensitive(foreignCatalog);
            boolean isForeignSchemaCaseSensitive = this.isCaseSensitive(foreignSchema);
            boolean isForeignTableCaseSensitive = this.isCaseSensitive(foreignTable);
            boolean nullReplacesEmpty = false;
            this.metadataQuery.appendView(primaryCatalog != null ? primaryCatalog : foreignCatalog, new String[]{"_V_JDBC_PKFK1", "_V_JDBC_PKFK2", "_V_JDBC_PKFK3"});
            this.metadataQuery.append(" WHERE TRUE ");
            if (isPrimCatalogCaseSensitive) {
                primaryCatalog = primaryCatalog.substring(1, primaryCatalog.length() - 1);
            }
            if (isPrimSchemaCaseSensitive) {
                primarySchema = primarySchema.substring(1, primarySchema.length() - 1);
            }
            if (isPrimTableCaseSensitive) {
                primaryTable = primaryTable.substring(1, primaryTable.length() - 1);
            }
            this.metadataQuery.appendCatalog("PKTABLE_CAT", primaryCatalog, isPrimCatalogCaseSensitive);
            this.metadataQuery.appendSchema("PKTABLE_SCHEM", primarySchema, isPrimSchemaCaseSensitive);
            this.metadataQuery.append("PKTABLE_NAME", primaryTable, isPrimTableCaseSensitive);
            if (isForeignCatalogCaseSensitive) {
                foreignCatalog = foreignCatalog.substring(1, foreignCatalog.length() - 1);
            }
            if (isForeignSchemaCaseSensitive) {
                foreignSchema = foreignSchema.substring(1, foreignSchema.length() - 1);
            }
            if (isForeignTableCaseSensitive) {
                foreignTable = foreignTable.substring(1, foreignTable.length() - 1);
            }
            this.metadataQuery.appendCatalog("FKTABLE_CAT", foreignCatalog, isForeignCatalogCaseSensitive);
            this.metadataQuery.appendSchema("FKTABLE_SCHEM", foreignSchema, isForeignSchemaCaseSensitive);
            this.metadataQuery.append("FKTABLE_NAME", foreignTable, isForeignTableCaseSensitive);
            if (foreignTable != null && foreignTable.length() != 0) {
                this.metadataQuery.append(" ORDER BY  FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ ");
            } else {
                this.metadataQuery.append(" ORDER BY  PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ ");
            }
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.connection.getDatabaseMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.connection.getDatabaseMinorVersion();
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return Driver.DATABASE_PRODUCT_NAME;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getDatabaseVersionString();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public int getDriverMajorVersion() {
        return Driver.MAJOR_VERSION;
    }

    @Override
    public int getDriverMinorVersion() {
        return Driver.MINOR_VERSION;
    }

    @Override
    public String getDriverName() throws SQLException {
        return Driver.NAME;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return Driver.VERSION;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String method = "getExportedKeys";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schema, table);
        return this.getCrossReference(catalog, schema, table, null, null, null);
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String method = "getImportedKeys";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schema, table);
        return this.getCrossReference(null, null, null, catalog, schema, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String method = "getIndexInfo";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schema, table, "" + unique, "" + approximate);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            boolean isCatalogCaseSensitive = this.isCaseSensitive(catalog);
            boolean isSchemaCaseSensitive = this.isCaseSensitive(schema);
            boolean isTableCaseSensitive = this.isCaseSensitive(table);
            boolean nullReplacesEmpty = false;
            this.metadataQuery.appendView(catalog, new String[]{"_V_JDBC_INDEXINFO1", "_V_JDBC_INDEXINFO2", "_V_JDBC_INDEXINFO3"});
            this.metadataQuery.append(" WHERE TRUE ");
            if (isCatalogCaseSensitive) {
                catalog = catalog.substring(1, catalog.length() - 1);
            }
            if (isSchemaCaseSensitive) {
                schema = schema.substring(1, schema.length() - 1);
            }
            if (isTableCaseSensitive) {
                table = table.substring(1, table.length() - 1);
            }
            this.metadataQuery.appendCatalog("TABLE_CAT", catalog, isCatalogCaseSensitive);
            this.metadataQuery.appendSchema("TABLE_SCHEM", schema, isSchemaCaseSensitive);
            this.metadataQuery.append("TABLE_NAME", table, isTableCaseSensitive);
            this.metadataQuery.append(" ORDER BY  NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 8192;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 65536;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return EscapeFunction.getNumericFunctions().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String method = "getPrimaryKeys";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schema, table);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            boolean isCatalogCaseSensitive = this.isCaseSensitive(catalog);
            boolean isSchemaCaseSensitive = this.isCaseSensitive(schema);
            boolean isTableCaseSensitive = this.isCaseSensitive(table);
            boolean nullReplacesEmpty = false;
            this.metadataQuery.appendView(catalog, new String[]{"_V_JDBC_PRIMARYKEYS1", "_V_JDBC_PRIMARYKEYS2", "_V_JDBC_PRIMARYKEYS3"});
            this.metadataQuery.append(" WHERE TRUE ");
            if (isCatalogCaseSensitive) {
                catalog = catalog.substring(1, catalog.length() - 1);
            }
            if (isSchemaCaseSensitive) {
                schema = schema.substring(1, schema.length() - 1);
            }
            if (isTableCaseSensitive) {
                table = table.substring(1, table.length() - 1);
            }
            this.metadataQuery.appendCatalog("TABLE_CAT", catalog, isCatalogCaseSensitive);
            this.metadataQuery.appendSchema("TABLE_SCHEM", schema, isSchemaCaseSensitive);
            this.metadataQuery.append("TABLE_NAME", table, isTableCaseSensitive);
            this.metadataQuery.append(" ORDER BY  COLUMN_NAME ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String method = "getProcedureColumns";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            boolean isCatalogCaseSensitive = this.isCaseSensitive(catalog);
            boolean isSchemaCaseSensitive = this.isCaseSensitive(schemaPattern);
            boolean isProcedureCaseSensitive = this.isCaseSensitive(procedureNamePattern);
            boolean isColumnCaseSensitive = this.isCaseSensitive(columnNamePattern);
            boolean nullReplacesEmpty = false;
            if (!NzFeature.STORED_PROCEDURE.isSet()) {
                throw new NzMethodNotImplementedException("NzDatabaseMetaData", "getProcedureColumns");
            }
            this.metadataQuery.appendView(catalog, new String[]{"_V_JDBC_PROCEDURE_COLUMNS1", "_V_JDBC_PROCEDURE_COLUMNS2", "_V_JDBC_PROCEDURE_COLUMNS3"});
            this.metadataQuery.append(" WHERE TRUE ");
            if (isCatalogCaseSensitive) {
                catalog = catalog.substring(1, catalog.length() - 1);
            }
            if (isSchemaCaseSensitive) {
                schemaPattern = schemaPattern.substring(1, schemaPattern.length() - 1);
            }
            if (isProcedureCaseSensitive) {
                procedureNamePattern = procedureNamePattern.substring(1, procedureNamePattern.length() - 1);
            }
            if (isColumnCaseSensitive) {
                columnNamePattern = columnNamePattern.substring(1, columnNamePattern.length() - 1);
            }
            this.metadataQuery.appendCatalog("PROCEDURE_CAT", catalog, isCatalogCaseSensitive);
            this.metadataQuery.appendSchema("PROCEDURE_SCHEM", schemaPattern, isSchemaCaseSensitive);
            this.metadataQuery.append("PROCEDURE_NAME", procedureNamePattern, isProcedureCaseSensitive);
            this.metadataQuery.append("COLUMN_NAME", columnNamePattern, isColumnCaseSensitive);
            this.metadataQuery.append(" ORDER BY  PROCEDURE_SCHEM, PROCEDURE_NAME ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String method = "getProcedures";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schemaPattern, procedureNamePattern);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            boolean isCatalogCaseSensitive = this.isCaseSensitive(catalog);
            boolean isSchemaCaseSensitive = this.isCaseSensitive(schemaPattern);
            boolean isProcedureCaseSensitive = this.isCaseSensitive(procedureNamePattern);
            boolean nullReplacesEmpty = false;
            if (!NzFeature.STORED_PROCEDURE.isSet()) {
                this.metadataQuery.reset();
                this.metadataQuery.append("select 'a' as PROCEDURE_CAT, 'a' as PROCEDURE_SCHEM, 'a' as PROCEDURE_NAME, 'a' as REMARKS, 0::INT2 as PROCEDURE_TYPE limit 0;");
                NzResultSet set = this.connection.execute(this.metadataQuery);
                this.connection.LOGGER.exit(this.getClass(), method, set);
                return set;
            }
            this.metadataQuery.appendView(catalog, new String[]{"_V_JDBC_PROCEDURES1", "_V_JDBC_PROCEDURES2", "_V_JDBC_PROCEDURES3"});
            this.metadataQuery.append(" WHERE TRUE ");
            if (isCatalogCaseSensitive) {
                catalog = catalog.substring(1, catalog.length() - 1);
            }
            if (isSchemaCaseSensitive) {
                schemaPattern = schemaPattern.substring(1, schemaPattern.length() - 1);
            }
            if (isProcedureCaseSensitive) {
                procedureNamePattern = procedureNamePattern.substring(1, procedureNamePattern.length() - 1);
            }
            this.metadataQuery.appendCatalog("PROCEDURE_CAT", catalog, isCatalogCaseSensitive);
            this.metadataQuery.appendSchema("PROCEDURE_SCHEM", schemaPattern, isSchemaCaseSensitive);
            this.metadataQuery.append("PROCEDURE_NAME", procedureNamePattern, isProcedureCaseSensitive);
            this.metadataQuery.append(" ORDER BY  PROCEDURE_SCHEM, PROCEDURE_NAME ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return SQL_KEYWORDS;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSchemas() throws SQLException {
        String method = "getSchemas";
        this.connection.LOGGER.entry(this.getClass(), method);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            if (NzFeature.SCHEMA_WORKAROUND.isSet()) {
                this.metadataQuery.append("_V_JDBC_SCHEMA3");
            } else if (NzFeature.CROSS_DATABASE.isSet()) {
                this.metadataQuery.append("_V_JDBC_SCHEMA2");
            } else if (NzFeature.CATALOG_API.isSet()) {
                this.metadataQuery.append("_V_JDBC_SCHEMA1");
            } else {
                NzCatalogCurruptException e = new NzCatalogCurruptException();
                this.connection.LOGGER.fatal(this.getClass(), method, e);
                throw e;
            }
            this.metadataQuery.append(" WHERE TABLE_CATALOG=current_catalog");
            this.metadataQuery.append(" ORDER BY  TABLE_SCHEM ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return EscapeFunction.getStringFunctions().toString();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new NzMethodNotImplementedException("NzDatabaseMetaData", "getSuperTables");
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new NzMethodNotImplementedException("NzDatabaseMetaData", "getSuperTypes");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return EscapeFunction.getSystemFunctions().toString();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new NzMethodNotImplementedException("NzDatabaseMetaData", "getTablePrivileges");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTableTypes() throws SQLException {
        String method = "getTableTypes";
        this.connection.LOGGER.entry(this.getClass(), method);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            if (NzFeature.SCHEMA_WORKAROUND.isSet()) {
                this.metadataQuery.append("_V_JDBC_TABLETYPES3");
            } else if (NzFeature.CROSS_DATABASE.isSet()) {
                this.metadataQuery.append("_V_JDBC_TABLETYPES2");
            } else if (NzFeature.CATALOG_API.isSet()) {
                this.metadataQuery.append("_V_JDBC_TABLETYPES1");
            } else {
                NzSQLException e = new NzSQLException("catalog corrupt", "HY000", 1100, new Object[0]);
                this.connection.LOGGER.fatal(this.getClass(), method, e);
                throw e;
            }
            this.metadataQuery.append(" ORDER BY  TABLE_TYPE ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String method = "getTables";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schemaPattern, tableNamePattern, types);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            boolean isCatalogCaseSensitive = this.isCaseSensitive(catalog);
            boolean isSchemaCaseSensitive = this.isCaseSensitive(schemaPattern);
            boolean isTableCaseSensitive = this.isCaseSensitive(tableNamePattern);
            boolean nullReplacesEmpty = false;
            this.metadataQuery.appendView(catalog, new String[]{"_V_JDBC_TABLES1", "_V_JDBC_TABLES2", "_V_JDBC_TABLES3"});
            this.metadataQuery.append(" WHERE TRUE ");
            if (isCatalogCaseSensitive) {
                catalog = catalog.substring(1, catalog.length() - 1);
            }
            if (isSchemaCaseSensitive) {
                schemaPattern = schemaPattern.substring(1, schemaPattern.length() - 1);
            }
            if (isTableCaseSensitive) {
                tableNamePattern = tableNamePattern.substring(1, tableNamePattern.length() - 1);
            }
            this.metadataQuery.appendCatalog("TABLE_CAT", catalog, isCatalogCaseSensitive);
            this.metadataQuery.appendSchema("TABLE_SCHEM", schemaPattern, isSchemaCaseSensitive);
            this.metadataQuery.append("TABLE_NAME", tableNamePattern, isTableCaseSensitive);
            this.metadataQuery.append(types);
            this.metadataQuery.append(" ORDER BY  TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return EscapeFunction.getDateNTimeFunctions().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTypeInfo() throws SQLException {
        String method = "getTypeInfo";
        this.connection.LOGGER.entry(this.getClass(), method);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            if (NzFeature.SCHEMA_WORKAROUND.isSet()) {
                this.metadataQuery.append("_V_JDBC_TYPEINFO3");
            } else if (NzFeature.CROSS_DATABASE.isSet()) {
                this.metadataQuery.append("_V_JDBC_TYPEINFO2");
            } else if (NzFeature.CATALOG_API.isSet()) {
                this.metadataQuery.append("_V_JDBC_TYPEINFO1");
            } else {
                NzCatalogCurruptException e = new NzCatalogCurruptException();
                this.connection.LOGGER.fatal(this.getClass(), method, e);
                throw e;
            }
            this.metadataQuery.append(" ORDER BY  DATA_TYPE ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String getUDTsSql = "select 'a' as TYPE_CAT, 'a' as TYPE_SCHEM, 'a' as TYPE_NAME, 'a' as CLASS_NAME, 1::INT4 as DATA_TYPE, 'a' as REMARKS, 1::INT2 as BASE_TYPE limit 0;";
        String method = "getUDTs";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schemaPattern, typeNamePattern, types);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append("select 'a' as TYPE_CAT, 'a' as TYPE_SCHEM, 'a' as TYPE_NAME, 'a' as CLASS_NAME, 1::INT4 as DATA_TYPE, 'a' as REMARKS, 1::INT2 as BASE_TYPE limit 0;");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getDatasource().getUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getDatasource().getUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String sql = "SELECT * FROM _V_JDBC_BESTROWIDENTIFIER1 LIMIT 0";
        String method = "getVersionColumns";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schema, table);
        this.connection.LOGGER.info(this.getClass(), method, "NOTICE: Netezza does not have any column types which are automatically updated or versionable.");
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append("SELECT * FROM _V_JDBC_BESTROWIDENTIFIER1 LIMIT 0");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new NzMethodNotImplementedException("NzDatabaseMetaData", "locatorsUpdateCopy");
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return !this.storesUpperCaseIdentifiers();
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.supportsMixedCaseIdentifiers();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.supportsMixedCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.connection.isUpperCase();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        switch (fromType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (toType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 1: 
            case 12: {
                switch (toType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
            case -3: {
                switch (toType) {
                    case -3: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (toType) {
                    case 1: 
                    case 12: 
                    case 91: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (toType) {
                    case 1: 
                    case 12: 
                    case 92: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (toType) {
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return concurrency == 1007 && type == 1003;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 2;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 8 || level == 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    protected static String escapeQuotes(String s) {
        int length = s.length();
        if (length == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int prevChar = 32;
        int prevPrevChar = 32;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            sb.append(c);
            if (c == '\'' && (prevChar != 92 || prevChar == 92 && prevPrevChar == 92)) {
                sb.append("'");
            }
            prevPrevChar = prevChar;
            prevChar = c;
        }
        return sb.toString();
    }

    protected int getMaxNameLength() throws SQLException {
        return 128;
    }

    private String appendConditionals(String srchElementValue, String srchElementName, boolean isSrchElementCaseSensitive, boolean nullReplacesEmpty) {
        String conditionalClause = " AND ";
        int elemValLen = srchElementValue.trim().length();
        if (nullReplacesEmpty && elemValLen == 0) {
            return conditionalClause + srchElementName + " = null ";
        }
        return conditionalClause + (isSrchElementCaseSensitive || elemValLen == 0 ? srchElementName + " LIKE '" + NzDatabaseMetadata.escapeQuotes(srchElementValue) + "'" : " UPPER(" + srchElementName + ") LIKE UPPER('" + NzDatabaseMetadata.escapeQuotes(srchElementValue) + "') ");
    }

    private boolean isCaseSensitive(String dbElem) {
        if (dbElem == null) {
            return false;
        }
        if ((dbElem = dbElem.trim()).length() == 0) {
            return false;
        }
        return dbElem.charAt(0) == '\"' && dbElem.charAt(dbElem.length() - 1) == '\"' || dbElem.charAt(0) == '\'' && dbElem.charAt(dbElem.length() - 1) == '\'';
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        String method = "autoCommitFailureClosesAllResultSets";
        this.connection.LOGGER.entry(this.getClass(), method);
        this.connection.LOGGER.exit(this.getClass(), method, false);
        return false;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        String method = "generatedKeyAlwaysReturned";
        this.connection.LOGGER.entry(this.getClass(), method);
        this.connection.LOGGER.exit(this.getClass(), method, false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        String method = "getClientInfoProperties";
        this.connection.LOGGER.entry(this.getClass(), method);
        if (this.connection.checkBackEndForGivenVersion("7.2.1") == -1) {
            NzSQLException etothrow = new NzSQLException("Feature is not supported by current NPS version", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            this.metadataQuery.append("_V_JDBC_CLIENT_INFO");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        String method = "getFunctionColumns";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schemaPattern, functionNamePattern, columnNamePattern);
        if (this.connection.checkBackEndForGivenVersion("7.2.1") == -1) {
            NzSQLException etothrow = new NzSQLException("Feature is not supported by current NPS version", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            boolean isCatalogCaseSensitive = this.isCaseSensitive(catalog);
            boolean isSchemaCaseSensitive = this.isCaseSensitive(schemaPattern);
            boolean isFunctionCaseSensitive = this.isCaseSensitive(functionNamePattern);
            boolean isColumnCaseSensitive = this.isCaseSensitive(columnNamePattern);
            this.metadataQuery.appendView(catalog, new String[]{"_V_JDBC_FUNCTION_COLUMNS1", "_V_JDBC_FUNCTION_COLUMNS2", "_V_JDBC_FUNCTION_COLUMNS3"});
            this.metadataQuery.append(" WHERE TRUE ");
            if (isCatalogCaseSensitive) {
                catalog = catalog.substring(1, catalog.length() - 1);
            }
            if (isSchemaCaseSensitive) {
                schemaPattern = schemaPattern.substring(1, schemaPattern.length() - 1);
            }
            if (isFunctionCaseSensitive) {
                functionNamePattern = functionNamePattern.substring(1, functionNamePattern.length() - 1);
            }
            if (isColumnCaseSensitive) {
                columnNamePattern = columnNamePattern.substring(1, columnNamePattern.length() - 1);
            }
            this.metadataQuery.appendCatalog("FUNCTION_CAT", catalog, isCatalogCaseSensitive);
            this.metadataQuery.appendSchema("FUNCTION_SCHEM", schemaPattern, isSchemaCaseSensitive);
            this.metadataQuery.append("FUNCTION_NAME", functionNamePattern, isFunctionCaseSensitive);
            this.metadataQuery.append("COLUMN_NAME", columnNamePattern, isColumnCaseSensitive);
            this.metadataQuery.append(" ORDER BY  FUNCTION_CAT, FUNCTION_SCHEM, FUNCTION_NAME ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        String method = "getFunctions";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schemaPattern, functionNamePattern);
        if (this.connection.checkBackEndForGivenVersion("7.2.1") == -1) {
            NzSQLException etothrow = new NzSQLException("Feature is not supported by current NPS version", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            boolean isCatalogCaseSensitive = this.isCaseSensitive(catalog);
            boolean isSchemaCaseSensitive = this.isCaseSensitive(schemaPattern);
            boolean isFunctionCaseSensitive = this.isCaseSensitive(functionNamePattern);
            this.metadataQuery.appendView(catalog, new String[]{"_V_JDBC_FUNCTION1", "_V_JDBC_FUNCTION2", "_V_JDBC_FUNCTION3"});
            this.metadataQuery.append(" WHERE TRUE ");
            if (isCatalogCaseSensitive) {
                catalog = catalog.substring(1, catalog.length() - 1);
            }
            if (isSchemaCaseSensitive) {
                schemaPattern = schemaPattern.substring(1, schemaPattern.length() - 1);
            }
            if (isFunctionCaseSensitive) {
                functionNamePattern = functionNamePattern.substring(1, functionNamePattern.length() - 1);
            }
            this.metadataQuery.appendCatalog("FUNCTION_CAT", catalog, isCatalogCaseSensitive);
            this.metadataQuery.appendSchema("FUNCTION_SCHEM", schemaPattern, isSchemaCaseSensitive);
            this.metadataQuery.append("FUNCTION_NAME", functionNamePattern, isFunctionCaseSensitive);
            this.metadataQuery.append(" ORDER BY  FUNCTION_CAT, FUNCTION_SCHEM, FUNCTION_NAME ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String method = "getPseudoColumns";
        this.connection.LOGGER.entry(this.getClass(), method, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        if (this.connection.checkBackEndForGivenVersion("7.2.1") == -1) {
            NzSQLException etothrow = new NzSQLException("Feature is not supported by current NPS version", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append("select rel.DATABASE AS TABLE_CAT, rel.OWNER AS TABLE_SCHEM, rel.NAME AS TABLE_NAME, O.ATTNAME AS COLUMN_NAME, CASE WHEN (FORMAT_SQL_DATATYPE(O.ATTTYPID) = -8) THEN -15 ELSE INT4(FORMAT_SQL_DATATYPE(O.ATTTYPID)) END AS DATA_TYPE, O.ATTLEN AS COLUMN_SIZE, NULL AS DECIMAL_DIGITS, 10 AS NUM_PREC_RADIX, ''::NVARCHAR(255) AS COLUMN_USAGE, ''::NVARCHAR(255) AS REMARKS, NULL AS CHAR_OCTET_LENGTH, CASE WHEN O.ATTNOTNULL = 't' THEN 'NO' ELSE 'YES' END IS_NULLABLE FROM (_T_ATTRIBUTE att JOIN _T_OBJECT obj ON att.attrelid = obj.objid) O JOIN _V_RELATION_COLUMN rel ON attrelid = rel.objid ");
            boolean isCatalogCaseSensitive = this.isCaseSensitive(catalog);
            boolean isSchemaCaseSensitive = this.isCaseSensitive(schemaPattern);
            boolean isTableCaseSensitive = this.isCaseSensitive(tableNamePattern);
            boolean isColumnCaseSensitive = this.isCaseSensitive(columnNamePattern);
            this.metadataQuery.append(" WHERE TRUE ");
            if (isCatalogCaseSensitive) {
                catalog = catalog.substring(1, catalog.length() - 1);
            }
            if (isSchemaCaseSensitive) {
                schemaPattern = schemaPattern.substring(1, schemaPattern.length() - 1);
            }
            if (isTableCaseSensitive) {
                tableNamePattern = tableNamePattern.substring(1, tableNamePattern.length() - 1);
            }
            if (isColumnCaseSensitive) {
                columnNamePattern = columnNamePattern.substring(1, columnNamePattern.length() - 1);
            }
            this.metadataQuery.append(" AND O.attnum < 0 ");
            this.metadataQuery.appendCatalog("TABLE_CAT", catalog, isCatalogCaseSensitive);
            this.metadataQuery.appendSchema("TABLE_SCHEM", schemaPattern, isSchemaCaseSensitive);
            this.metadataQuery.append("TABLE_NAME", tableNamePattern, isTableCaseSensitive);
            this.metadataQuery.append("COLUMN_NAME", columnNamePattern, isColumnCaseSensitive);
            this.metadataQuery.append(" ORDER BY TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String method = "getSchemas";
        this.connection.LOGGER.entry(this.getClass(), method);
        MetaDataQuery metaDataQuery = this.metadataQuery;
        synchronized (metaDataQuery) {
            this.metadataQuery.reset();
            this.metadataQuery.append(" SELECT * FROM ");
            if (NzFeature.SCHEMA_WORKAROUND.isSet()) {
                this.metadataQuery.append("_V_JDBC_SCHEMA3");
            } else if (NzFeature.CROSS_DATABASE.isSet()) {
                this.metadataQuery.append("_V_JDBC_SCHEMA2");
            } else if (NzFeature.CATALOG_API.isSet()) {
                this.metadataQuery.append("_V_JDBC_SCHEMA1");
            } else {
                NzCatalogCurruptException e = new NzCatalogCurruptException();
                this.connection.LOGGER.fatal(this.getClass(), method, e);
                throw e;
            }
            this.metadataQuery.append(" WHERE TRUE ");
            boolean isCatalogCaseSensitive = this.isCaseSensitive(catalog);
            if (isCatalogCaseSensitive) {
                catalog = catalog.substring(1, catalog.length() - 1);
            }
            this.metadataQuery.appendCatalog("TABLE_CATALOG", catalog, isCatalogCaseSensitive);
            boolean isSchemaCaseSensitive = this.isCaseSensitive(schemaPattern);
            if (isSchemaCaseSensitive) {
                schemaPattern = schemaPattern.substring(1, schemaPattern.length() - 1);
            }
            this.metadataQuery.appendSchema("TABLE_SCHEM", schemaPattern, isSchemaCaseSensitive);
            this.metadataQuery.append(" ORDER BY  TABLE_SCHEM ");
            NzResultSet set = this.connection.execute(this.metadataQuery);
            this.connection.LOGGER.exit(this.getClass(), method, set);
            return set;
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("isWrapperFor");
        this.connection.LOGGER.fatal(this.getClass(), "isWrapperFor", etothrow);
        throw etothrow;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("unwrap");
        this.connection.LOGGER.fatal(this.getClass(), "unwrap", etothrow);
        throw etothrow;
    }

    public class NzCatalogCurruptException
    extends NzSQLException {
        private static final String key = "netezza.catalog.corrupt";

        public NzCatalogCurruptException() {
            super(key, "HY000", 1100, new Object[0]);
        }
    }

    private class MetaDataQuery
    extends NzQuery {
        private boolean specCompliantDBMeta;
        private final StringBuilder queryBuilder = new StringBuilder();

        public MetaDataQuery() {
            this.specCompliantDBMeta = NzDatabaseMetadata.this.connection.getDatasource().getSpecCompliantDBMeta();
        }

        @Override
        public NzQuery.QueryType getQueryType() {
            return NzQuery.QueryType.SELECT;
        }

        public void append(String[] types) {
            if (types != null) {
                String typesIn = "";
                typesIn = typesIn + " and TABLE_TYPE IN (";
                for (int i = 0; i < types.length; ++i) {
                    typesIn = typesIn + "'" + NzDatabaseMetadata.escapeQuotes(types[i].toUpperCase()) + "'";
                    if (i >= types.length - 1) continue;
                    typesIn = typesIn + ",";
                }
                typesIn = typesIn + ")";
                this.queryBuilder.append(typesIn);
            }
        }

        @Override
        public boolean isParsed() {
            return true;
        }

        @Override
        public NzQuery parse() throws ParseException {
            return this;
        }

        @Override
        public String toNativeString() {
            return this.queryBuilder.toString();
        }

        @Override
        public String toString() {
            return this.queryBuilder.toString();
        }

        public void append(String clause) {
            this.queryBuilder.append(clause);
        }

        public void append(Object token) {
            this.queryBuilder.append(String.valueOf(token));
        }

        public void appendView(String catalog, String[] vList) throws SQLException {
            String method = "appendView";
            catalog = catalog == null ? "" : catalog;
            catalog = catalog.trim();
            String string = catalog = catalog.length() == 0 ? catalog : catalog + "..";
            if (NzFeature.SCHEMA_WORKAROUND.isSet()) {
                NzDatabaseMetadata.this.metadataQuery.append(catalog);
                NzDatabaseMetadata.this.metadataQuery.append(vList[2]);
            } else if (NzFeature.CROSS_DATABASE.isSet()) {
                NzDatabaseMetadata.this.metadataQuery.append(catalog);
                NzDatabaseMetadata.this.metadataQuery.append(vList[1]);
            } else if (NzFeature.CATALOG_API.isSet()) {
                NzDatabaseMetadata.this.metadataQuery.append(vList[0]);
            } else {
                NzCatalogCurruptException e = new NzCatalogCurruptException();
                ((NzDatabaseMetadata)NzDatabaseMetadata.this).connection.LOGGER.fatal(this.getClass(), method, e);
                throw e;
            }
        }

        public void appendCatalog(String columnName, String catalog, boolean isCatalogCaseSensitive) {
            if (catalog != null) {
                this.queryBuilder.append(NzDatabaseMetadata.this.appendConditionals(catalog, columnName, isCatalogCaseSensitive, true));
            } else if (!this.specCompliantDBMeta) {
                this.queryBuilder.append(" AND " + columnName + "=" + NzDatabaseMetadata.defaultCatalog);
            }
        }

        public void appendSchema(String columnName, String schema, boolean isSchemaCaseSensitive) {
            if (schema != null) {
                this.queryBuilder.append(NzDatabaseMetadata.this.appendConditionals(schema, columnName, isSchemaCaseSensitive, true));
            } else if (!NzFeature.SCHEMA_WORKAROUND.isSet() && !this.specCompliantDBMeta) {
                this.queryBuilder.append(" AND " + columnName + "=" + NzDatabaseMetadata.defaultSchema);
            }
        }

        public void append(String elemName, String elemValue, boolean isElemCaseSensitive) {
            if (elemValue != null) {
                NzDatabaseMetadata.this.metadataQuery.append(NzDatabaseMetadata.this.appendConditionals(elemValue, elemName, isElemCaseSensitive, false));
            }
        }

        public void reset() {
            this.queryBuilder.setLength(0);
        }
    }

    private static interface ColumnNameList {
        public static final String CATALOG = "TABLE_CAT";
        public static final String SCHEMA = "TABLE_SCHEM";
        public static final String TABLE = "TABLE_NAME";
        public static final String PROCEDURE = "PROCEDURE_NAME";
        public static final String COLUMN = "COLUMN_NAME";
        public static final String PROCEDURE_CATALOG = "PROCEDURE_CAT";
        public static final String PROCEDURE_SCHEMA = "PROCEDURE_SCHEM";
        public static final String FUNCTION_CATALOG = "FUNCTION_CAT";
        public static final String FUNCTION_SCHEMA = "FUNCTION_SCHEM";
        public static final String FUNCTION = "FUNCTION_NAME";
        public static final String SCHEMA_CATALOG = "TABLE_CATALOG";
    }

    private static interface ViewList {
        public static final String BEST_ROW_IDENTIFIER3 = "_V_JDBC_BESTROWIDENTIFIER3";
        public static final String BEST_ROW_IDENTIFIER2 = "_V_JDBC_BESTROWIDENTIFIER2";
        public static final String BEST_ROW_IDENTIFIER1 = "_V_JDBC_BESTROWIDENTIFIER1";
        public static final String CATALOG3 = "_V_JDBC_CATALOG3 ";
        public static final String CATALOG2 = "_V_JDBC_CATALOG2 ";
        public static final String CATALOG1 = "_V_JDBC_CATALOG1 ";
        public static final String COLUMNS3 = "_V_JDBC_COLUMNS3";
        public static final String COLUMNS2 = "_V_JDBC_COLUMNS2";
        public static final String COLUMNS1 = "_V_JDBC_COLUMNS1";
        public static final String INDEX_INFO3 = "_V_JDBC_INDEXINFO3";
        public static final String INDEX_INFO2 = "_V_JDBC_INDEXINFO2";
        public static final String INDEX_INFO1 = "_V_JDBC_INDEXINFO1";
        public static final String PKFK3 = "_V_JDBC_PKFK3";
        public static final String PKFK2 = "_V_JDBC_PKFK2";
        public static final String PKFK1 = "_V_JDBC_PKFK1";
        public static final String PRIMARY_KEY3 = "_V_JDBC_PRIMARYKEYS3";
        public static final String PRIMARY_KEY2 = "_V_JDBC_PRIMARYKEYS2";
        public static final String PRIMARY_KEY1 = "_V_JDBC_PRIMARYKEYS1";
        public static final String SCHEMA3 = "_V_JDBC_SCHEMA3";
        public static final String SCHEMA2 = "_V_JDBC_SCHEMA2";
        public static final String SCHEMA1 = "_V_JDBC_SCHEMA1";
        public static final String TABLES3 = "_V_JDBC_TABLES3";
        public static final String TABLES2 = "_V_JDBC_TABLES2";
        public static final String TABLES1 = "_V_JDBC_TABLES1";
        public static final String TABLE_TYPE3 = "_V_JDBC_TABLETYPES3";
        public static final String TABLE_TYPE2 = "_V_JDBC_TABLETYPES2";
        public static final String TABLE_TYPE1 = "_V_JDBC_TABLETYPES1";
        public static final String TYPE_INFO3 = "_V_JDBC_TYPEINFO3";
        public static final String TYPE_INFO2 = "_V_JDBC_TYPEINFO2";
        public static final String TYPE_INFO1 = "_V_JDBC_TYPEINFO1";
        public static final String PROCEDURES3 = "_V_JDBC_PROCEDURES3";
        public static final String PROCEDURES2 = "_V_JDBC_PROCEDURES2";
        public static final String PROCEDURES1 = "_V_JDBC_PROCEDURES1";
        public static final String PROCEDURECOLUMNS3 = "_V_JDBC_PROCEDURE_COLUMNS3";
        public static final String PROCEDURECOLUMNS2 = "_V_JDBC_PROCEDURE_COLUMNS2";
        public static final String PROCEDURECOLUMNS1 = "_V_JDBC_PROCEDURE_COLUMNS1";
        public static final String FUNCTIONS1 = "_V_JDBC_FUNCTION1";
        public static final String FUNCTIONS2 = "_V_JDBC_FUNCTION2";
        public static final String FUNCTIONS3 = "_V_JDBC_FUNCTION3";
        public static final String FUNCTIONCOLUMNS1 = "_V_JDBC_FUNCTION_COLUMNS1";
        public static final String FUNCTIONCOLUMNS2 = "_V_JDBC_FUNCTION_COLUMNS2";
        public static final String FUNCTIONCOLUMNS3 = "_V_JDBC_FUNCTION_COLUMNS3";
        public static final String CLIENT_INFO_PROPERTIES = "_V_JDBC_CLIENT_INFO";
        public static final String PSEUDO_COLUMNS = "select rel.DATABASE AS TABLE_CAT, rel.OWNER AS TABLE_SCHEM, rel.NAME AS TABLE_NAME, O.ATTNAME AS COLUMN_NAME, CASE WHEN (FORMAT_SQL_DATATYPE(O.ATTTYPID) = -8) THEN -15 ELSE INT4(FORMAT_SQL_DATATYPE(O.ATTTYPID)) END AS DATA_TYPE, O.ATTLEN AS COLUMN_SIZE, NULL AS DECIMAL_DIGITS, 10 AS NUM_PREC_RADIX, ''::NVARCHAR(255) AS COLUMN_USAGE, ''::NVARCHAR(255) AS REMARKS, NULL AS CHAR_OCTET_LENGTH, CASE WHEN O.ATTNOTNULL = 't' THEN 'NO' ELSE 'YES' END IS_NULLABLE FROM (_T_ATTRIBUTE att JOIN _T_OBJECT obj ON att.attrelid = obj.objid) O JOIN _V_RELATION_COLUMN rel ON attrelid = rel.objid ";
    }

    private static interface ClauseList {
        public static final String SELECT_ALL_FROM = " SELECT * FROM ";
        public static final String WHERE = " WHERE TRUE ";
        public static final String ORDER_BY = " ORDER BY ";
        public static final String AND = " AND ";
        public static final String OR = " OR ";
    }
}

