/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.dc;

import com.dbeaver.ee.dc.client.DCClientConfiguration;
import com.dbeaver.ee.dc.client.DCRemoteSecurityController;
import com.dbeaver.ee.model.auth.SMApplicationIdentityProvider;
import com.dbeaver.ee.runtime.auth.CredentialsCallback;
import com.dbeaver.ui.auth.dc.DCWorkspaceSession;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.BaseWorkspaceImpl;
import org.jkiss.dbeaver.registry.BasicWorkspaceSession;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.SecurityUtils;

public class DCIdentityProvider
implements SMApplicationIdentityProvider {
    private static final Log log = Log.getLog(DCIdentityProvider.class);
    private static final String PROP_DC_SERVER_URL = "dbeaver.auth.dc.service_url";
    public static final String DEFAULT_DC_HOST_NAME = "dc.cloudbeaver";
    public static final String DEFAULT_DC_URL = "http://dc.cloudbeaver:8970";
    private static final int[] DEFAULT_DC_PORTS;
    private static final String[] DEFAULT_DC_PROTOCOLS;
    private InetAddress autoDetectedAddr;
    private String autoDetectedURL;

    static {
        int[] nArray = new int[2];
        nArray[1] = 8970;
        DEFAULT_DC_PORTS = nArray;
        DEFAULT_DC_PROTOCOLS = new String[]{"https", "http"};
    }

    public boolean isDefaultForCurrentEnvironment() {
        try {
            this.detectDomainControllerEndpoint();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void detectDomainControllerEndpoint() throws DBException {
        this.autoDetectedURL = System.getProperty(PROP_DC_SERVER_URL);
        if (this.autoDetectedURL != null) {
            return;
        }
        log.debug((Object)"Searching for DC server");
        if (this.autoDetectedAddr == null) {
            try {
                this.autoDetectedAddr = InetAddress.getByName(DEFAULT_DC_HOST_NAME);
            }
            catch (UnknownHostException unknownHostException) {
                throw new DBException("Default domain controller host dc.cloudbeaver can't be resolved");
            }
        }
        int[] nArray = DEFAULT_DC_PORTS;
        int n = DEFAULT_DC_PORTS.length;
        int n2 = 0;
        while (n2 < n) {
            int portNumber = nArray[n2];
            String[] stringArray = DEFAULT_DC_PROTOCOLS;
            int n3 = DEFAULT_DC_PROTOCOLS.length;
            int n4 = 0;
            while (n4 < n3) {
                String protocol = stringArray[n4];
                String urlString = String.valueOf(protocol) + "://" + this.autoDetectedAddr.getHostName();
                if (portNumber > 0) {
                    urlString = String.valueOf(urlString) + ":" + portNumber;
                }
                try {
                    URL url = new URL(urlString);
                    Throwable throwable = null;
                    Object var12_13 = null;
                    try (InputStream urlConnection = url.openStream();){
                        this.autoDetectedURL = urlString;
                        log.debug((Object)("Found DC server at " + urlString));
                        return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    ++n4;
                }
            }
            ++n2;
        }
        throw new DBException("Can't detect DC server endpoint");
    }

    @NotNull
    public SMSession acquireApplicationSession(@NotNull DBRProgressMonitor monitor, @NotNull DBPWorkspace workspace, @NotNull CallbackHandler handler) throws DBException {
        if (this.autoDetectedURL == null) {
            this.detectDomainControllerEndpoint();
        }
        BasicWorkspaceSession testSession = new BasicWorkspaceSession(workspace);
        String appSessionId = BaseWorkspaceImpl.readWorkspaceId();
        CredentialsCallback credentials = new CredentialsCallback();
        credentials.setUsername(testSession.getUserName());
        while (true) {
            try {
                handler.handle(new Callback[]{credentials});
            }
            catch (Exception e) {
                throw new DBException("Error getting user credentials:\n" + e.getMessage());
            }
            DCClientConfiguration clientConfig = ((DCClientConfiguration.Builder)DCClientConfiguration.builder().setApiUrl(this.autoDetectedURL)).build();
            DCRemoteSecurityController svc = new DCRemoteSecurityController(clientConfig);
            LinkedHashMap sessionParams = new LinkedHashMap();
            LinkedHashMap<String, String> userCredentials = new LinkedHashMap<String, String>();
            userCredentials.put("user", credentials.getUsername());
            userCredentials.put("password", SecurityUtils.makeDigest((String)credentials.getPassword()));
            try {
                SMAuthInfo dcAuthInfo = svc.authenticate(appSessionId, sessionParams, BasicWorkspaceSession.DB_SESSION_TYPE, "local", userCredentials);
                return new DCWorkspaceSession(workspace, clientConfig, dcAuthInfo);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showMessageBox("Authentication error", e.getMessage(), true);
                continue;
            }
            break;
        }
    }
}

