/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.ui.views;

import com.dbeaver.db.teradata.ui.TeradataMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ext.generic.views.GenericConnectionPage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class TeradataConnectionPage
extends GenericConnectionPage {
    private Button enableTLS;
    private Button hierarchyTree;

    public void createAdvancedSettingsGroup(Composite composite) {
        Group advancedSettings = new Group(composite, 0);
        advancedSettings.setText(TeradataMessages.connection_page_control_group_advanced_settings);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        advancedSettings.setLayoutData((Object)gridData);
        advancedSettings.setLayout((Layout)new GridLayout(1, false));
        this.enableTLS = UIUtils.createCheckbox((Composite)advancedSettings, (String)TeradataMessages.connection_page_checkbox_label_enable_TLS, (String)TeradataMessages.connection_page_checkbox_description_enable_TLS, (boolean)false, (int)1);
        this.enableTLS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeradataConnectionPage.this.updateHostPortAndUrl();
            }
        });
        this.hierarchyTree = UIUtils.createCheckbox((Composite)advancedSettings, (String)TeradataMessages.connection_page_checkbox_hierarchy_view_label, (String)TeradataMessages.connection_page_checkbox_hierarchy_view_tip, (boolean)true, (int)1);
    }

    private void updateHostPortAndUrl() {
        boolean enabled = this.enableTLS.getSelection();
        if (enabled) {
            this.setPortText("443");
        } else {
            this.setPortText("1025");
        }
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        this.enableTLS.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("use-tls-protocol@")));
        this.hierarchyTree.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("show-db-hierarchically@")));
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.enableTLS != null) {
            connectionInfo.setProviderProperty("use-tls-protocol@", String.valueOf(this.enableTLS.getSelection()));
        }
        if (this.hierarchyTree != null) {
            connectionInfo.setProviderProperty("show-db-hierarchically@", String.valueOf(this.hierarchyTree.getSelection()));
        }
        super.saveSettings(dataSource);
    }
}

