/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.application;

import com.dbeaver.ee.model.auth.SMApplicationIdentityProvider;
import com.dbeaver.ee.runtime.auth.CredentialsCallback;
import com.dbeaver.ee.runtime.auth.IdentityProviderRegistry;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.EclipseWorkspaceImpl;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseAuthDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class EclipseWorkspaceImplAdvanced
extends EclipseWorkspaceImpl {
    private static final Log log = Log.getLog(EclipseWorkspaceImplAdvanced.class);

    public EclipseWorkspaceImplAdvanced(@NotNull DBPPlatform platform, @NotNull IWorkspace eclipseWorkspace) {
        super(platform, eclipseWorkspace);
    }

    @NotNull
    protected SMSession acquireWorkspaceSession(@NotNull DBRProgressMonitor monitor) throws DBException {
        SMApplicationIdentityProvider identityProvider = IdentityProviderRegistry.getInstance().getGlobalIdentityProvider();
        return this.acquireSession(monitor, (DBPWorkspace)this, identityProvider);
    }

    @NotNull
    private SMSession acquireSession(@NotNull DBRProgressMonitor monitor, @NotNull DBPWorkspace workspace, @NotNull SMApplicationIdentityProvider provider) throws DBException {
        return provider.acquireApplicationSession(monitor, workspace, callbacks -> {
            Callback[] callbackArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Callback callback = callbackArray[n2];
                if (callback instanceof CredentialsCallback) {
                    CredentialsCallback credentials = (CredentialsCallback)callback;
                    DBPAuthInfo info = this.showCredentialsPrompt(credentials.getUsername(), credentials.getPassword());
                    if (info == null) {
                        throw new IOException("Authentication has been canceled");
                    }
                    credentials.setUsername(info.getUserName());
                    credentials.setPassword(info.getUserPassword());
                } else if (callback instanceof TextOutputCallback) {
                    TextOutputCallback message = (TextOutputCallback)callback;
                    switch (message.getMessageType()) {
                        case 0: {
                            this.showMessageBox(message.getMessage(), message.getMessage(), 2);
                            break;
                        }
                        case 1: {
                            this.showMessageBox(message.getMessage(), message.getMessage(), 8);
                            break;
                        }
                        case 2: {
                            this.showMessageBox(message.getMessage(), message.getMessage(), 1);
                            break;
                        }
                    }
                } else {
                    throw new UnsupportedCallbackException(callback);
                }
                ++n2;
            }
        });
    }

    @Nullable
    private DBPAuthInfo showCredentialsPrompt(final @Nullable String username, final @Nullable String password) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        WorkbenchPlugin.unsetSplashShell((Display)display);
        final Shell shell = new Shell(display, 16416);
        shell.setText(GeneralUtils.getProductTitle());
        try {
            DBPAuthInfo dBPAuthInfo = (DBPAuthInfo)new UITask<DBPAuthInfo>(){

                protected DBPAuthInfo runTask() {
                    BaseAuthDialog authDialog = new BaseAuthDialog(shell, "Enter credentials", false, false);
                    authDialog.setUserName(username);
                    authDialog.setUserPassword(password);
                    if (authDialog.open() == 0) {
                        return authDialog.getAuthInfo();
                    }
                    return null;
                }
            }.execute();
            return dBPAuthInfo;
        }
        finally {
            shell.dispose();
        }
    }

    private void showMessageBox(@NotNull String title, @NotNull String message, int type) {
        try {
            UIUtils.showMessageBox((Shell)WorkbenchPlugin.getSplashShell((Display)Display.getCurrent()), (String)title, (String)message, (int)type);
        }
        catch (Exception exception) {
            log.error((Object)message);
        }
    }
}

