/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.ActivityStreamStatus;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopActivityStreamResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, StopActivityStreamResponse> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(StopActivityStreamResponse.getter(StopActivityStreamResponse::kmsKeyId)).setter(StopActivityStreamResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> KINESIS_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KinesisStreamName").getter(StopActivityStreamResponse.getter(StopActivityStreamResponse::kinesisStreamName)).setter(StopActivityStreamResponse.setter(Builder::kinesisStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StopActivityStreamResponse.getter(StopActivityStreamResponse::statusAsString)).setter(StopActivityStreamResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, KINESIS_STREAM_NAME_FIELD, STATUS_FIELD));
    private final String kmsKeyId;
    private final String kinesisStreamName;
    private final String status;

    private StopActivityStreamResponse(BuilderImpl builder) {
        super(builder);
        this.kmsKeyId = builder.kmsKeyId;
        this.kinesisStreamName = builder.kinesisStreamName;
        this.status = builder.status;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String kinesisStreamName() {
        return this.kinesisStreamName;
    }

    public final ActivityStreamStatus status() {
        return ActivityStreamStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopActivityStreamResponse)) {
            return false;
        }
        StopActivityStreamResponse other = (StopActivityStreamResponse)((Object)obj);
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.kinesisStreamName(), other.kinesisStreamName()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StopActivityStreamResponse").add("KmsKeyId", (Object)this.kmsKeyId()).add("KinesisStreamName", (Object)this.kinesisStreamName()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "KinesisStreamName": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopActivityStreamResponse, T> g) {
        return obj -> g.apply((StopActivityStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private String kinesisStreamName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StopActivityStreamResponse model) {
            super(model);
            this.kmsKeyId(model.kmsKeyId);
            this.kinesisStreamName(model.kinesisStreamName);
            this.status(model.status);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getKinesisStreamName() {
            return this.kinesisStreamName;
        }

        public final void setKinesisStreamName(String kinesisStreamName) {
            this.kinesisStreamName = kinesisStreamName;
        }

        @Override
        @Transient
        public final Builder kinesisStreamName(String kinesisStreamName) {
            this.kinesisStreamName = kinesisStreamName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ActivityStreamStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public StopActivityStreamResponse build() {
            return new StopActivityStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopActivityStreamResponse> {
        public Builder kmsKeyId(String var1);

        public Builder kinesisStreamName(String var1);

        public Builder status(String var1);

        public Builder status(ActivityStreamStatus var1);
    }
}

